/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis.handler;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.email.EmailPackage;
import com.techempower.gemini.email.outbound.EmailTemplater;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormHidden;
import com.techempower.gemini.form.FormPasswordField;
import com.techempower.gemini.form.FormSubmitButton;
import com.techempower.gemini.form.FormTextField;
import com.techempower.gemini.form.FormValidation;
import com.techempower.gemini.form.PostOnlyForm;
import com.techempower.gemini.form.validator.PasswordComplexityValidator;
import com.techempower.gemini.path.MethodPathHandler;
import com.techempower.gemini.path.annotation.PathDefault;
import com.techempower.gemini.path.annotation.PathSegment;
import com.techempower.gemini.pyxis.BasicWebUser;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.password.PasswordProposal;
import com.techempower.helper.StringHelper;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.HashMap;

public class PasswordResetHandler<C extends Context>
extends MethodPathHandler<C>
implements Configurable {
    public static final String COMPONENT_CODE = "hPsR";
    public static final String DEFAULT_TEMPLATE_PATH = "auth/";
    public static final int DEFAULT_EXPIRATION_DAYS = 5;
    public static final String DEFAULT_BASE_URI = "password-reset";
    public static final String TEMPLATE_RESET_REQUEST = "password-reset-request";
    public static final String TEMPLATE_RESET_CONFIRMED = "password-reset-request-confirmed";
    public static final String TEMPLATE_RESET = "password-reset-process";
    public static final String TEMPLATE_RESET_COMPLETE = "password-reset-complete";
    public static final String TEMPLATE_RESET_NOT_FOUND = "password-reset-not-found";
    public static final String EMAIL_TEMPLATE_NAME = "E-PasswordResetAuthorization";
    private final PyxisSecurity security;
    private String fromAddress = "";
    private int expirationDays = 5;
    private String templateRelativePath = "auth/";
    private String baseUri = "password-reset";

    public PasswordResetHandler(GeminiApplication application) {
        super(application, COMPONENT_CODE);
        this.security = application.getSecurity();
        EmailTemplater templater = application.getEmailTemplater();
        templater.addTemplateToLoad(this.getEmailTemplateName());
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
        EnhancedProperties.Focus focus = props.focus("PasswordReset.");
        this.fromAddress = focus.getProperty("FromAddress", this.fromAddress);
        this.expirationDays = focus.getIntegerProperty("ExpirationDays", 5);
        this.templateRelativePath = focus.getProperty("TemplateRelativePath", DEFAULT_TEMPLATE_PATH);
        this.baseUri = focus.getProperty("BaseUri", DEFAULT_BASE_URI);
    }

    protected Form buildResetForm(Context context) {
        PostOnlyForm resetForm = new PostOnlyForm(this.app(), "requestpwr", context.getUrl());
        FormTextField usernameField = new FormTextField("Your user name", "un", "", true, 100, 100);
        FormSubmitButton submitButton = new FormSubmitButton("submit", "Submit", true);
        resetForm.add(usernameField);
        resetForm.add(submitButton);
        return resetForm;
    }

    @PathDefault
    public boolean resetRequest(Context context) {
        Form resetForm = this.buildResetForm(context);
        context.delivery().putObject("form", resetForm);
        if (resetForm.hasBeenSubmitted(context)) {
            FormValidation validation = resetForm.validate(context);
            if (validation.isGood()) {
                String username = resetForm.values().get("un");
                BasicWebUser user = (BasicWebUser)this.security.getUser(username);
                if (user != null) {
                    String ticket = user.generateNewPasswordResetTicket(this.expirationDays);
                    this.saveUser(user);
                    this.sendAuthorizationEmail(context, user, ticket);
                    return this.mustache(String.valueOf(this.templateRelativePath) + TEMPLATE_RESET_CONFIRMED);
                }
                context.delivery().put("message", "Sorry, a user with that user name was not found.");
            } else {
                context.delivery().putObject("validation", validation);
            }
        }
        return this.mustache(String.valueOf(this.templateRelativePath) + TEMPLATE_RESET_REQUEST);
    }

    protected void sendAuthorizationEmail(Context context, BasicWebUser user, String ticket) {
        EmailTemplater templater = this.app().getEmailTemplater();
        HashMap<String, Object> macros = new HashMap<String, Object>();
        macros.put("$UN", user.getUserUsername());
        macros.put("$FN", user.getUserFirstname());
        macros.put("$LN", user.getUserLastname());
        macros.put("$EM", user.getUserEmail());
        macros.put("$VT", ticket);
        macros.put("$ED", "" + this.expirationDays);
        macros.put("$URL", this.getAuthorizationUrl(user, ticket));
        String authorAddress = this.getFromAddress();
        EmailPackage email = templater.process(this.getEmailTemplateName(), macros, authorAddress, user.getUserEmail());
        if (email != null) {
            this.app().getEmailServicer().sendMail(email);
        } else {
            this.l("Email could not be fetched from EmailTemplater.");
        }
    }

    protected String getFromAddress() {
        if (StringHelper.isEmpty(this.fromAddress)) {
            this.l("Using administrator e-mail address for sending password-reset email.", 0);
            return this.app().getAdministratorEmail();
        }
        return this.fromAddress;
    }

    protected String getAuthorizationUrl(BasicWebUser user, String ticket) {
        String url = String.valueOf(this.app().getInfrastructure().getSecureUrl()) + this.baseUri + "/auth?" + "un=" + user.getUserUsername() + "&vt=" + ticket;
        return url;
    }

    protected void saveUser(BasicWebUser user) {
        this.store().put(user);
    }

    @PathSegment(value="auth")
    public boolean authorize(Context context) {
        String username = this.query().get("un");
        String ticket = this.query().get("vt");
        BasicWebUser user = (BasicWebUser)this.security.getUser(username);
        if (user != null) {
            if (user.isPasswordResetAuthorized(ticket)) {
                PostOnlyForm resetForm = new PostOnlyForm(this.app(), "resetpw", context.getUrl());
                resetForm.add(new FormHidden("un", username, true));
                resetForm.add(new FormHidden("vt", ticket, true));
                FormPasswordField newPwField = new FormPasswordField("New Password", "pw", "", true, 30, 30);
                newPwField.setConfirm(true, true);
                newPwField.addValidator(new PasswordComplexityValidator(this.security, user));
                resetForm.add(newPwField);
                FormSubmitButton submitButton = new FormSubmitButton("submit", "Submit", true);
                resetForm.add(submitButton);
                context.delivery().putObject("form", resetForm);
                if (resetForm.hasBeenSubmitted(context)) {
                    FormValidation validation = resetForm.validate(context);
                    if (validation.isGood()) {
                        PasswordProposal proposal = new PasswordProposal(newPwField.getStringValue(), user.getUserUsername(), user, context);
                        this.security.passwordChange(proposal);
                        user.setPasswordResetTicket("");
                        user.setPasswordResetExpiration(null);
                        this.saveUser(user);
                        return this.mustache(String.valueOf(this.templateRelativePath) + TEMPLATE_RESET_COMPLETE);
                    }
                    context.delivery().putObject("validation", validation);
                }
                return this.mustache(String.valueOf(this.templateRelativePath) + TEMPLATE_RESET);
            }
            context.delivery().put("message", "Invalid password-reset ticket.");
        } else {
            context.delivery().put("message", "User not found.");
        }
        return this.mustache(String.valueOf(this.templateRelativePath) + TEMPLATE_RESET_NOT_FOUND);
    }

    protected String getEmailTemplateName() {
        return EMAIL_TEMPLATE_NAME;
    }
}

