/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis.listener;

import com.techempower.cache.EntityStore;
import com.techempower.data.EntityGroup;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.listener.SecurityListener;
import com.techempower.gemini.pyxis.password.PasswordProposal;
import com.techempower.util.BasicIdentifiable;
import java.util.Date;

public class LoginAuditListener<C extends Context>
implements SecurityListener<C> {
    public static final String SESSION_REFERENCE_LOGIN = "-ReferenceLoginID";
    private final EntityStore cache;

    public <G extends GeminiApplication> LoginAuditListener(G application) {
        this.cache = application.getStore();
        this.cache.register(EntityGroup.of(SecurityAuditEvent.class));
    }

    @Override
    public void loginSuccessful(C context, PyxisUser user) {
        SecurityAuditEvent audit = new SecurityAuditEvent();
        audit.setTime(new Date()).setType(this.getLoginType(context)).setUserId(user.getId());
        this.cache.put(audit);
        ((Context)context).session().put(SESSION_REFERENCE_LOGIN, audit.getId());
    }

    @Override
    public void logoutSuccessful(C context, PyxisUser user) {
        SecurityAuditEvent audit = new SecurityAuditEvent();
        int referenceLogin = ((Context)context).session().getInt(SESSION_REFERENCE_LOGIN, 0);
        ((Context)context).session().remove(SESSION_REFERENCE_LOGIN);
        audit.setTime(new Date()).setType(this.getLogoutType(context)).setUserId(user.getId()).setReferenceLogin(referenceLogin);
        this.cache.put(audit);
    }

    @Override
    public void loginFailed(C context) {
    }

    protected int getLoginType(C context) {
        return 0;
    }

    protected int getLogoutType(C context) {
        return 1;
    }

    @Override
    public void passwordChanged(PasswordProposal proposal) {
    }

    public static class SecurityAuditEvent
    extends BasicIdentifiable {
        public static final int TYPE_LOGIN = 0;
        public static final int TYPE_LOGOUT = 1;
        private int userId;
        private Date time;
        private int type;
        private int referenceLogin;

        public SecurityAuditEvent setUserId(int userid) {
            this.userId = userid;
            return this;
        }

        public int getUserId() {
            return this.userId;
        }

        public SecurityAuditEvent setTime(Date time) {
            this.time = time;
            return this;
        }

        public Date getTime() {
            return this.time;
        }

        public SecurityAuditEvent setType(int type) {
            this.type = type;
            return this;
        }

        public int getType() {
            return this.type;
        }

        public SecurityAuditEvent setReferenceLogin(int id) {
            this.referenceLogin = id;
            return this;
        }

        public int getReferenceLogin() {
            return this.referenceLogin;
        }
    }
}

