/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis.password;

import com.techempower.gemini.pyxis.password.PasswordHasher;
import java.util.Objects;
import org.mindrot.jbcrypt.BCrypt;

public class BCryptPasswordHasher
implements PasswordHasher {
    @Override
    public String encryptPassword(String cleartextPassword) {
        return BCrypt.hashpw((String)cleartextPassword, (String)BCrypt.gensalt());
    }

    @Override
    public boolean testPassword(String cleartextPassword, String encryptedPassword) {
        if (encryptedPassword != null && encryptedPassword.startsWith("$2a$")) {
            return BCrypt.checkpw((String)cleartextPassword, (String)encryptedPassword);
        }
        return Objects.equals(cleartextPassword, encryptedPassword);
    }

    @Override
    public String getName() {
        return "BCrypt";
    }

    @Override
    public boolean isSecure() {
        return true;
    }
}

