/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis.password;

import com.techempower.cache.EntityStore;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.listener.SecurityListener;
import com.techempower.gemini.pyxis.password.PasswordHistory;
import com.techempower.gemini.pyxis.password.PasswordProposal;
import com.techempower.gemini.pyxis.password.PasswordRequirement;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;

public class PasswordHistoryManager
implements SecurityListener<Context>,
PasswordRequirement,
Configurable {
    public static final String COMPONENT_CODE = "PsHs";
    public static final int HARD_MAXIMUM_HISTORY_SIZE = 100;
    public static final int DEFAULT_MAXIMUM_HISTORY_SIZE = 5;
    private final ComponentLog log;
    private final PyxisSecurity security;
    private final EntityStore store;
    private int maximumHistorySize = 5;
    private boolean captureNonPrincipalChanges = false;

    public PasswordHistoryManager(GeminiApplication application, PyxisSecurity security) {
        this.log = application.getLog(COMPONENT_CODE);
        this.security = security;
        this.store = application.getStore();
        security.addListener(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
        EnhancedProperties.Focus focus = props.focus("PasswordHistory.");
        this.maximumHistorySize = focus.getIntegerProperty("MaximumHistorySize", 5, 1, 100);
        this.captureNonPrincipalChanges = focus.getYesNoProperty("CaptureNonPrincipalChanges", false);
        if (!this.security.getPasswordHasher().isSecure()) {
            throw new IllegalArgumentException("PasswordHistoryManager cannot be used with an insecure password hasher. Provided: " + this.security.getPasswordHasher().getName() + ".");
        }
    }

    @Override
    public void passwordChanged(PasswordProposal proposal) {
        PyxisUser cause = this.security.getUser(proposal.context);
        if (this.captureNonPrincipalChanges || proposal.user == cause) {
            PasswordHistory history = this.store.get(PasswordHistory.class, proposal.user.getId());
            if (history == null) {
                history = new PasswordHistory();
                history.setId(proposal.user.getId());
            }
            this.log.log("Recording new password hash for " + proposal.username + ".");
            history.addHash(proposal.hashedPassword, this.maximumHistorySize);
            this.store.put(history);
        }
    }

    @Override
    public String validate(PasswordProposal proposal) {
        PasswordHistory history = this.store.get(PasswordHistory.class, proposal.user.getId());
        if (history != null) {
            String[] hashes = history.getHashesArray();
            this.log.log("Checking proposed new password for " + proposal.username + " against " + hashes.length + " previous hashes.");
            String[] stringArray = hashes;
            int n = hashes.length;
            int n2 = 0;
            while (n2 < n) {
                String hash = stringArray[n2];
                if (this.security.getPasswordHasher().testPassword(proposal.password, hash)) {
                    this.log.log("Proposed new password for " + proposal.username + " matches a previous hash; it does not pass validation.");
                    return "The provided password was used previously. Please create a new password.";
                }
                ++n2;
            }
            this.log.log("Proposed new password for " + proposal.username + " is not in recent history; it passes validation.");
        }
        return null;
    }

    @Override
    public void loginSuccessful(Context context, PyxisUser user) {
    }

    @Override
    public void logoutSuccessful(Context context, PyxisUser user) {
    }

    @Override
    public void loginFailed(Context context) {
    }
}

