/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.session;

import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.session.HttpSession;
import com.techempower.gemini.session.SessionManager;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import javax.servlet.http.HttpServletRequest;

public class HttpSessionManager
implements SessionManager {
    public static final String COMPONENT_CODE = "mSes";
    public static final int DEFAULT_TIMEOUT = 3600;
    public static final String SESSION_HASH = "Gemini-Session-Hash";
    private int timeoutSeconds = 3600;
    private ComponentLog log;
    private boolean refererTracking = false;
    private long sessionAccumulator = 0L;
    private boolean strictSessions = false;

    public HttpSessionManager(GeminiApplication application) {
        this.log = application.getLog(COMPONENT_CODE);
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.setTimeoutSeconds(props.getIntegerProperty("SessionTimeout", 3600));
        this.refererTracking = props.getYesNoProperty("RefererTracking", this.refererTracking);
        if (this.refererTracking) {
            this.log.log("Referer tracking enabled.");
        }
        this.strictSessions = props.getYesNoProperty("StrictSessions", this.strictSessions);
        if (this.strictSessions) {
            this.log.log("Scrict sessions enabled.");
        }
    }

    public void setTimeoutMinutes(int minutes) {
        this.timeoutSeconds = minutes * 60;
    }

    public void setTimeoutSeconds(int seconds) {
        this.timeoutSeconds = seconds;
    }

    @Override
    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public HttpSession getSession(HttpServletRequest request, boolean create) {
        HttpSession session = HttpSession.createSession(request.getSession(create));
        if (session == null) {
            return null;
        }
        boolean newSession = session.isNew();
        if (this.strictSessions) {
            if (newSession) {
                int requestHash = this.getRequestHash(request);
                session.setAttribute(SESSION_HASH, "" + requestHash);
            } else {
                int requestHash = this.getRequestHash(request);
                int sessionHash = 0;
                try {
                    sessionHash = Integer.parseInt((String)session.getAttribute(SESSION_HASH));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (requestHash != sessionHash) {
                    this.log.log("Session hash mismatch.  Invalidating session " + session.getId());
                    session.invalidate();
                    session = HttpSession.createSession(request.getSession(true));
                    session.setAttribute(SESSION_HASH, "" + requestHash);
                    newSession = true;
                }
            }
        }
        if (newSession) {
            session.setMaxInactiveInterval(this.timeoutSeconds);
            session.setAttribute("Gemini-Session-ID", this.constructSessionID());
            if (this.refererTracking && request.getHeader("referer") != null) {
                session.setAttribute("Gemini-Referer", request.getHeader("referer"));
            }
        }
        return session;
    }

    protected int getRequestHash(HttpServletRequest request) {
        String toHash = request.getHeader("User-Agent") + request.getHeader("Accept-Charset") + request.getHeader("Keep-Alive");
        return toHash.hashCode();
    }

    protected String constructSessionID() {
        StringBuilder sessionID = new StringBuilder(13);
        ++this.sessionAccumulator;
        String sessionSequenceNumber = Long.toString(this.sessionAccumulator, 36);
        int i = sessionSequenceNumber.length();
        while (i < 5) {
            sessionID.append('0');
            ++i;
        }
        sessionID.append(sessionSequenceNumber);
        String timeStamp = Long.toString(System.currentTimeMillis(), 36);
        int i2 = timeStamp.length();
        while (i2 < 8) {
            sessionID.append('0');
            ++i2;
        }
        sessionID.append(timeStamp);
        return sessionID.toString();
    }
}

