/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.simulation;

import com.techempower.gemini.BasicInfrastructure;
import com.techempower.gemini.Cookie;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.Infrastructure;
import com.techempower.gemini.Request;
import com.techempower.gemini.Simulation;
import com.techempower.gemini.session.Session;
import com.techempower.gemini.simulation.SimClient;
import com.techempower.gemini.simulation.SimCookie;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class SimRequest
implements Request {
    private final GeminiApplication application;
    private final BasicInfrastructure infrastructure;
    private String url;
    private final String uri;
    private final String requestSignature;
    private String queryString;
    private Hashtable<String, String> parameters;
    private final List<SimCookie> cookies = new ArrayList<SimCookie>();
    private String redirectURL;
    private boolean redirected = false;
    private String renderedJSP;
    private String includedFile;

    public SimRequest(Simulation simulation, String url, Map<String, String> parameters, SimClient client, GeminiApplication application) {
        this.application = application;
        this.infrastructure = this.application.getInfrastructure();
        this.parameters = parameters == null ? new Hashtable() : new Hashtable<String, String>(parameters);
        this.requestSignature = url;
        String[] urlSplit = url.split("\\?");
        if (urlSplit.length > 1) {
            this.queryString = urlSplit[1];
            String[] params = urlSplit[1].split("&");
            int i = 0;
            while (i < params.length) {
                String[] keyValuePair = params[i].split("=");
                this.parameters.put(keyValuePair[0], keyValuePair[1]);
                ++i;
            }
        }
        this.uri = this.url = urlSplit[0];
    }

    @Override
    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return null;
    }

    @Override
    public String getHeader(String name) {
        return null;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return this.parameters.keys();
    }

    @Override
    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public void putParameter(String name, String value) {
        if (value != null) {
            this.parameters.put(name, value);
        }
    }

    @Override
    public void removeParameter(String name) {
    }

    @Override
    public void removeAllRequestValues() {
    }

    @Override
    public String[] getParameterValues(String name) {
        return null;
    }

    @Override
    public String encodeURL(String urlToEncode) {
        return urlToEncode;
    }

    @Override
    public void print(String text) throws IOException {
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return null;
    }

    @Override
    public String getRequestSignature() {
        return this.requestSignature;
    }

    @Override
    public String getRealPath(String path) {
        return path;
    }

    @Override
    public String getContextPath() {
        return "";
    }

    @Override
    public StringBuffer getRequestURL() {
        return new StringBuffer(this.url);
    }

    @Override
    public String getRequestURI() {
        return this.uri;
    }

    @Override
    public <C extends Cookie> C getCookie(String name) {
        for (SimCookie cookie : this.cookies) {
            if (!cookie.getName().equals(name)) continue;
            return (C)cookie;
        }
        return null;
    }

    @Override
    public void setCookie(String name, String value, String path, int age, boolean secure) {
        SimCookie cookie = new SimCookie(name, value, path, age, secure);
        this.cookies.add(cookie);
    }

    @Override
    public void deleteCookie(String name, String path) {
        Iterator<SimCookie> iter = this.cookies.iterator();
        while (iter.hasNext()) {
            SimCookie cookie = iter.next();
            if (!cookie.getName().equals(name) || !cookie.getPath().equals(path)) continue;
            iter.remove();
            break;
        }
    }

    @Override
    public String getClientID() {
        return null;
    }

    @Override
    public String getRequestMethod() {
        return null;
    }

    @Override
    public boolean redirect(String redirectDestinationUrl) {
        this.redirectURL = redirectDestinationUrl;
        this.redirected = true;
        return true;
    }

    @Override
    public boolean redirectPermanent(String redirectDestinationUrl) {
        return false;
    }

    @Override
    public void setResponseHeader(String headerName, String value) {
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public boolean render(String path, boolean fullyQualified) throws Exception {
        this.renderedJSP = path;
        return true;
    }

    @Override
    public String renderToString(String path) {
        return "";
    }

    @Override
    public Infrastructure getInfrastructure() {
        return this.infrastructure;
    }

    @Override
    public void setContentType(String contentType) {
    }

    @Override
    public void setExpiration(int secondsFromNow) {
    }

    @Override
    public String getCurrentURI() {
        return null;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean isCommitted() {
        return false;
    }

    @Override
    public void sendError(int error) throws IOException {
    }

    @Override
    public void sendError(int error, String message) throws IOException {
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public Session getSession(boolean create) {
        return this.application.getSimSessionManager().getSession(create, this);
    }

    @Override
    public void setAttribute(String name, Object o) {
    }

    @Override
    public Object getAttribute(String name) {
        return null;
    }

    @Override
    public void setRewritten(boolean rewritten) {
    }

    @Override
    public boolean includeFile(File file, String fileName, boolean asAttachment, String contentType) {
        this.includedFile = file.getAbsolutePath();
        return true;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public boolean redirected() {
        return this.redirected;
    }

    public String getRenderedJSP() {
        return this.renderedJSP;
    }

    public String getIncludedFile() {
        return this.includedFile;
    }

    @Override
    public void setStatus(int status) {
    }

    @Override
    public boolean isPost() {
        return false;
    }

    @Override
    public boolean isHead() {
        return false;
    }

    @Override
    public boolean isGet() {
        return false;
    }

    @Override
    public boolean isPut() {
        return false;
    }

    @Override
    public boolean isDelete() {
        return false;
    }

    @Override
    public boolean isTrace() {
        return false;
    }

    @Override
    public boolean isOptions() {
        return false;
    }

    @Override
    public boolean isConnect() {
        return false;
    }

    @Override
    public boolean isPatch() {
        return false;
    }

    @Override
    public HttpServletRequest getRawRequest() {
        throw new UnsupportedOperationException("Simulated requests do not provide raw requests.");
    }

    @Override
    public HttpServletResponse getRawResponse() {
        throw new UnsupportedOperationException("Simulated requests do not provide raw responses.");
    }

    @Override
    public ServletContext getServletContext() {
        throw new UnsupportedOperationException("Simulated requests do not ServletContexts.");
    }
}

