/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import com.techempower.helper.StringHelper;
import com.techempower.text.SynchronizedDecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public final class CurrencyHelper {
    public static final SynchronizedDecimalFormat STANDARD_US_CURRENCY_FORMAT = new SynchronizedDecimalFormat("\u00a4#,##0.00;(#,##0.00)");
    public static final SynchronizedDecimalFormat NOSYMBOL_US_CURRENCY_FORMAT = new SynchronizedDecimalFormat("#,##0.00;(#,##0.00)");
    public static final SynchronizedDecimalFormat NOGROUPING_US_CURRENCY_FORMAT = new SynchronizedDecimalFormat("0.00");
    public static final SynchronizedDecimalFormat NODECIMAL_US_CURRENCY_FORMAT = new SynchronizedDecimalFormat("\u00a4###,###");

    public static String formatUS(double d) {
        return NumberFormat.getCurrencyInstance(Locale.US).format(d);
    }

    public static String formatUSNoDecimal(double d) {
        return NODECIMAL_US_CURRENCY_FORMAT.format(d);
    }

    public static String formatUS(float f) {
        return NumberFormat.getCurrencyInstance(Locale.US).format(f);
    }

    public static String formatUS(int number) {
        return NODECIMAL_US_CURRENCY_FORMAT.format(number);
    }

    public static String formatUSCents(int cents) {
        return String.valueOf(NODECIMAL_US_CURRENCY_FORMAT.format(cents / 100)) + "." + StringHelper.padZero(Math.abs(cents) % 100, 2);
    }

    private CurrencyHelper() {
    }
}

