/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import com.techempower.text.SynchronizedSimpleDateFormat;
import com.techempower.util.StringList;
import com.techempower.util.TimeZoneDescriptor;
import com.techempower.util.UtilityConstants;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

public final class DateHelper {
    private static final List<SimpleDateFormat> DEFAULT_DATE_FORMATTERS = new ArrayList<SimpleDateFormat>();
    public static final SynchronizedSimpleDateFormat SHORT_US_DATE_FORMAT = new SynchronizedSimpleDateFormat("MM/dd/yy");
    public static final SynchronizedSimpleDateFormat STANDARD_US_DATE_FORMAT = new SynchronizedSimpleDateFormat("MM/dd/yyyy");
    public static final SynchronizedSimpleDateFormat STANDARD_UK_DATE_FORMAT = new SynchronizedSimpleDateFormat("dd MMM yyyy");
    public static final SynchronizedSimpleDateFormat STANDARD_FULL_DATE_FORMAT = new SynchronizedSimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    public static final SynchronizedSimpleDateFormat STANDARD_FULL_DATE_FORMAT_12 = new SynchronizedSimpleDateFormat("MM/dd/yyyy hh:mm:ss aa");
    public static final SynchronizedSimpleDateFormat STANDARD_FULL_DATE_FORMAT_UK = new SynchronizedSimpleDateFormat("dd MMM yyyy hh:mm:ss aa");
    public static final SynchronizedSimpleDateFormat STANDARD_SQL_FORMAT = new SynchronizedSimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final SynchronizedSimpleDateFormat STANDARD_TECH_FORMAT = new SynchronizedSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SynchronizedSimpleDateFormat STANDARD_TECH_FORMAT_DATEONLY = new SynchronizedSimpleDateFormat("yyyy-MM-dd");
    public static final SynchronizedSimpleDateFormat STANDARD_TECH_FORMAT_12 = new SynchronizedSimpleDateFormat("yyyy-MM-dd hh:mm:ss aa");
    public static final SynchronizedSimpleDateFormat STANDARD_TECH_FORMAT_WITHDAY = new SynchronizedSimpleDateFormat("EEE yyyy-MM-dd");
    public static final SynchronizedSimpleDateFormat STANDARD_FILENAME_FORMAT = new SynchronizedSimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
    public static final SynchronizedSimpleDateFormat VERBOSE_TECH_FORMAT = new SynchronizedSimpleDateFormat("EEE yyyy-MM-dd HH:mm:ss");
    public static final SynchronizedSimpleDateFormat VERBOSE_TECH_FORMAT_12 = new SynchronizedSimpleDateFormat("EEE yyyy-MM-dd hh:mm:ss aa");
    private static final TimeZoneDescriptor[] SIMPLE_TIME_ZONES = new TimeZoneDescriptor[]{new TimeZoneDescriptor(0, "America/Los_Angeles", "Pacific Time (United States)"), new TimeZoneDescriptor(1, "America/Denver", "Mountain Time (United States)"), new TimeZoneDescriptor(2, "America/Chicago", "Central Time (United States)"), new TimeZoneDescriptor(3, "America/New_York", "Eastern Time (United States)"), new TimeZoneDescriptor(4, "GMT-1200", "UTC-12: Baker Island, Howland Island"), new TimeZoneDescriptor(5, "GMT-1100", "UTC-11: American Samoa, Samoa"), new TimeZoneDescriptor(6, "GMT-1000", "UTC-10: Hawaii, Papeete"), new TimeZoneDescriptor(7, "GMT-0900", "UTC-09: Anchorage, Fairbanks, Juneau"), new TimeZoneDescriptor(8, "GMT-0800", "UTC-08: California, Las Vegas, Portland, Washington state"), new TimeZoneDescriptor(9, "GMT-0700", "UTC-07: Arizona, Colorado"), new TimeZoneDescriptor(10, "GMT-0600", "UTC-06: Chicago, Dallas, Houston"), new TimeZoneDescriptor(11, "GMT-0500", "UTC-05: Boston, Miami, New York, Washington D.C."), new TimeZoneDescriptor(12, "GMT-0400", "UTC-04: Dominican Republic, Nova Scotia, Puerto Rico"), new TimeZoneDescriptor(13, "GMT-0300", "UTC-03: Argentina, Uruguay"), new TimeZoneDescriptor(14, "GMT-0200", "UTC-02: South Georgia and the South Sandwich Islands"), new TimeZoneDescriptor(15, "GMT-0100", "UTC-01: Azores, Cape Verde"), new TimeZoneDescriptor(16, "UTC", "UTC: Coordinated Universal Time"), new TimeZoneDescriptor(17, "GMT+0100", "UTC+01: Germany, Italy, Switzerland"), new TimeZoneDescriptor(18, "GMT+0200", "UTC+02: Greece, Israel, Romania, Syria"), new TimeZoneDescriptor(19, "GMT+0300", "UTC+03: Ethiopia, Iraq, Kenya, Saudi Arabia"), new TimeZoneDescriptor(20, "GMT+0400", "UTC+04: Moscow, United Arab Emirates"), new TimeZoneDescriptor(21, "GMT+0500", "UTC+05: Kazakhstan, Uzbekistan"), new TimeZoneDescriptor(22, "GMT+0600", "UTC+06: Bangladesh, Novosibirsk"), new TimeZoneDescriptor(23, "GMT+0700", "UTC+07: Jakarta, Thailand, Vietnam"), new TimeZoneDescriptor(24, "GMT+0800", "UTC+08: China, Hong Kong, Singapore"), new TimeZoneDescriptor(25, "GMT+0900", "UTC+09: Japan, Korea"), new TimeZoneDescriptor(26, "GMT+1000", "UTC+10: New South Wales, Queensland, Victoria"), new TimeZoneDescriptor(27, "GMT+1100", "UTC+11: Kamchatka, New Caledonia, Solomon Islands"), new TimeZoneDescriptor(28, "GMT+1200", "UTC+12: Fiji, New Zealand"), new TimeZoneDescriptor(29, "GMT+1300", "UTC+13: Tonga"), new TimeZoneDescriptor(30, "GMT+1400", "UTC+14: Line Islands")};
    private static final Calendar CALENDAR_INSTANCE = Calendar.getInstance();
    private static long nextDay = 0L;
    private static Calendar startOfMonth = null;
    private static Calendar startOfDay = null;
    private static Calendar endOfMonth = null;
    private static Calendar endOfDay = null;
    private static TimeZone systemTimeZone = null;
    private static int currentTimeZoneOffset = 0;
    private static final Object LOCK_OBJECT = new Object();
    private static final String DELTA_DATE_TOKENS = "+-hdwmy";
    private static final String[] HUMAN_DATE_LABELS;
    private static final long[] HUMAN_DATE_AMOUNTS;
    private static final int ONE_CENTURY = 100;
    private static final int FOUR_CENTURIES = 400;

    static {
        int iFormatIndex = 0;
        while (iFormatIndex < UtilityConstants.PERMITTED_DATE_FORMATS.length) {
            SimpleDateFormat theFormat = new SimpleDateFormat(UtilityConstants.PERMITTED_DATE_FORMATS[iFormatIndex]);
            theFormat.setLenient(false);
            DEFAULT_DATE_FORMATTERS.add(iFormatIndex, theFormat);
            ++iFormatIndex;
        }
        HUMAN_DATE_LABELS = new String[]{"year", "week", "day", "hour", "minute", "second"};
        HUMAN_DATE_AMOUNTS = new long[]{31536000000L, 604800000L, 86400000L, 3600000L, 60000L, 1000L};
    }

    public static boolean isInRange(Date date, Date rangeStart, Date rangeEnd) {
        if (date == null) {
            return rangeStart == null && rangeEnd == null;
        }
        if (rangeStart != null && rangeStart.compareTo(date) > 0) {
            return false;
        }
        return rangeEnd == null || rangeEnd.compareTo(date) >= 0;
    }

    public static boolean isInRange(Calendar date, Calendar rangeStart, Calendar rangeEnd) {
        if (date == null) {
            return rangeStart == null && rangeEnd == null;
        }
        if (rangeStart != null && rangeStart.compareTo(date) > 0) {
            return false;
        }
        return rangeEnd == null || rangeEnd.compareTo(date) >= 0;
    }

    public static void adjustStartOfDay(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static void adjustEndOfDay(Calendar cal) {
        DateHelper.adjustStartOfDay(cal);
        cal.add(6, 1);
        cal.add(14, -1);
    }

    public static void adjustStartOfMonth(Calendar cal) {
        cal.set(5, 1);
        DateHelper.adjustStartOfDay(cal);
    }

    public static void adjustEndOfMonth(Calendar cal) {
        DateHelper.adjustStartOfMonth(cal);
        cal.add(2, 1);
        cal.add(14, -1);
    }

    public static Calendar getStartOfMonth(int year, int month) {
        Calendar toReturn = DateHelper.getCalendarInstance();
        toReturn.clear();
        toReturn.set(year, month - 1, 1);
        return toReturn;
    }

    public static Calendar getEndOfMonth(int year, int month) {
        Calendar toReturn = DateHelper.getStartOfMonth(year, month);
        toReturn.add(2, 1);
        toReturn.add(14, -1);
        return toReturn;
    }

    public static Calendar getStartOfMonth() {
        DateHelper.recalculateCalendarObjects();
        return DateHelper.copy(startOfMonth);
    }

    public static Calendar getEndOfMonth() {
        DateHelper.recalculateCalendarObjects();
        return DateHelper.copy(endOfMonth);
    }

    public static boolean isThisMonth(Calendar calendar) {
        return calendar != null && DateHelper.getStartOfMonth().compareTo(calendar) <= 0 && DateHelper.getEndOfMonth().compareTo(calendar) >= 0;
    }

    public static Calendar getStartOfDay() {
        DateHelper.recalculateCalendarObjects();
        return DateHelper.copy(startOfDay);
    }

    public static Calendar getEndOfDay() {
        DateHelper.recalculateCalendarObjects();
        return DateHelper.copy(endOfDay);
    }

    public static TimeZone getSystemTimeZone() {
        DateHelper.recalculateCalendarObjects();
        return systemTimeZone;
    }

    public static TimeZone getSimpleTimeZone(int id) {
        if (id >= 0 && id < SIMPLE_TIME_ZONES.length) {
            return SIMPLE_TIME_ZONES[id].getTimeZone();
        }
        return SIMPLE_TIME_ZONES[0].getTimeZone();
    }

    public static TimeZoneDescriptor[] getSimpleTimeZones() {
        return (TimeZoneDescriptor[])SIMPLE_TIME_ZONES.clone();
    }

    public static int getSimpleTimeZonesMaxIndex() {
        return SIMPLE_TIME_ZONES.length;
    }

    public static int getCurrentTimeZoneOFfset() {
        DateHelper.recalculateCalendarObjects();
        return currentTimeZoneOffset;
    }

    public static boolean isToday(Calendar calendar) {
        return calendar != null && DateHelper.getStartOfDay().compareTo(calendar) <= 0 && DateHelper.getEndOfDay().compareTo(calendar) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void recalculateCalendarObjects() {
        long currentTime = System.currentTimeMillis();
        if (nextDay == 0L || currentTime > nextDay) {
            Object object = LOCK_OBJECT;
            synchronized (object) {
                Calendar cal = DateHelper.getCalendarInstance();
                currentTime += (long)cal.getTimeZone().getOffset(currentTime);
                currentTime -= currentTime % 86400000L;
                startOfDay = (Calendar)cal.clone();
                DateHelper.adjustStartOfDay(startOfDay);
                endOfDay = (Calendar)startOfDay.clone();
                DateHelper.adjustEndOfDay(endOfDay);
                startOfMonth = (Calendar)startOfDay.clone();
                DateHelper.adjustStartOfMonth(startOfMonth);
                endOfMonth = (Calendar)startOfMonth.clone();
                DateHelper.adjustEndOfMonth(endOfMonth);
                systemTimeZone = TimeZone.getDefault();
                currentTimeZoneOffset = systemTimeZone.getOffset(currentTime);
                nextDay = currentTime + 86400000L;
            }
        }
    }

    public static Date copy(Date date) {
        return date != null ? (Date)date.clone() : null;
    }

    public static Calendar copy(Calendar calendar) {
        return calendar != null ? (Calendar)calendar.clone() : null;
    }

    public static boolean isPast(Date date) {
        if (date == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        return date.getTime() < now;
    }

    public static boolean isFuture(Date date) {
        if (date == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        return date.getTime() > now;
    }

    public static boolean deltaDate(Calendar input, String delta) {
        boolean success = false;
        if (input != null && StringHelper.isNonEmpty(delta)) {
            StringTokenizer tokenizer = new StringTokenizer(delta, DELTA_DATE_TOKENS, true);
            int lastAmount = 0;
            boolean addition = true;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("+")) {
                    addition = true;
                    continue;
                }
                if (token.equals("-")) {
                    addition = false;
                    continue;
                }
                if (DELTA_DATE_TOKENS.contains(token)) {
                    int field = 5;
                    switch (token.charAt(0)) {
                        case 'h': {
                            field = 11;
                            break;
                        }
                        case 'w': {
                            field = 3;
                            break;
                        }
                        case 'm': {
                            field = 2;
                            break;
                        }
                        case 'y': {
                            field = 1;
                            break;
                        }
                    }
                    if (addition) {
                        input.add(field, lastAmount);
                    } else {
                        input.add(field, -lastAmount);
                    }
                    lastAmount = 0;
                    success = true;
                    continue;
                }
                lastAmount = NumberHelper.parseInt(token, 0);
            }
        }
        return success;
    }

    public static int getDifference(Date date1, Date date2, long timeUnitInMillis) {
        if (date1 != null && date2 != null) {
            long t1 = date1.getTime();
            long t2 = date2.getTime();
            return (int)((t2 - t1) / timeUnitInMillis);
        }
        return 0;
    }

    public static int getDifferenceSince(Date date1, long timeUnitInMillis) {
        if (date1 != null) {
            long t1 = date1.getTime();
            long t2 = System.currentTimeMillis();
            return (int)((t2 - t1) / timeUnitInMillis);
        }
        return 0;
    }

    public static String getHumanDifference(Date date1, Date date2, int specificity) {
        if (date1 != null && date2 != null && specificity > 0) {
            long difference = Math.abs(date1.getTime() - date2.getTime());
            return DateHelper.getHumanDuration(difference, specificity);
        }
        return "";
    }

    public static String getHumanDifference(long millis1, long millis2, int specificity) {
        long difference = Math.abs(millis1 - millis2);
        return DateHelper.getHumanDuration(difference, specificity);
    }

    public static String getHumanDifference(long millis, int specificity) {
        return DateHelper.getHumanDifference(millis, System.currentTimeMillis(), specificity);
    }

    public static String getHumanDuration(long milliseconds, int specificity) {
        long ms = milliseconds;
        StringList toReturn = new StringList(", ");
        int level = 0;
        if (ms < 1000L) {
            return "Less than 1 second";
        }
        int i = 0;
        while (i < HUMAN_DATE_LABELS.length) {
            int count = (int)(ms / HUMAN_DATE_AMOUNTS[i]);
            if (count > 0) {
                toReturn.add(String.valueOf(count) + " " + HUMAN_DATE_LABELS[i] + StringHelper.pluralize(count));
                if (++level == specificity) {
                    return toReturn.toString();
                }
                ms -= (long)count * HUMAN_DATE_AMOUNTS[i];
            }
            ++i;
        }
        return toReturn.toString();
    }

    public static Calendar parseDelta(Calendar input, String delta, TimeZone timeZone) {
        Calendar toReturn = DateHelper.parse(delta, timeZone);
        if (toReturn == null) {
            Calendar start;
            Calendar calendar = start = input != null ? (Calendar)input.clone() : DateHelper.getCalendarInstance();
            if (DateHelper.deltaDate(start, delta)) {
                toReturn = start;
            }
        }
        return toReturn;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static List<SimpleDateFormat> getDefaultDateFormatters() {
        return new ArrayList<SimpleDateFormat>(DEFAULT_DATE_FORMATTERS);
    }

    public static boolean isValid(String date) {
        return DateHelper.isValid(date, DEFAULT_DATE_FORMATTERS);
    }

    public static boolean isValid(String date, List<SimpleDateFormat> dateFormatters) {
        return DateHelper.isValid(date, dateFormatters, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValid(String date, List<SimpleDateFormat> dateFormatters, AtomicInteger indexOfValidFormatter) {
        if (date == null) {
            return false;
        }
        List<SimpleDateFormat> formatters = dateFormatters == null || dateFormatters.size() <= 0 ? DEFAULT_DATE_FORMATTERS : dateFormatters;
        int iIndex = 0;
        while (iIndex < formatters.size()) {
            SimpleDateFormat dateFormat;
            SimpleDateFormat simpleDateFormat = dateFormat = formatters.get(iIndex);
            synchronized (simpleDateFormat) {
                if (dateFormat.parse(date, new ParsePosition(0)) != null) {
                    if (indexOfValidFormatter != null) {
                        indexOfValidFormatter.set(iIndex);
                    }
                    return true;
                }
            }
            ++iIndex;
        }
        if (indexOfValidFormatter != null) {
            indexOfValidFormatter.set(-1);
        }
        return false;
    }

    public static String format(Calendar theCalendar, int dateStyle, int timeStyle) {
        return DateHelper.format(theCalendar, dateStyle, timeStyle, "", "");
    }

    public static String format(Calendar theCalendar, int dateStyle, int timeStyle, String alternateDateSeparator, String dateTimeSpacer) {
        String stringValue = dateTimeSpacer.equalsIgnoreCase("") ? DateFormat.getDateTimeInstance(dateStyle, timeStyle).format(theCalendar.getTime()) : String.valueOf(DateFormat.getDateInstance(dateStyle).format(theCalendar.getTime())) + dateTimeSpacer + DateFormat.getTimeInstance(timeStyle).format(theCalendar.getTime());
        if (!alternateDateSeparator.equalsIgnoreCase("")) {
            StringHelper.replaceSubstrings(stringValue, new String[]{"."}, new String[]{alternateDateSeparator});
        }
        return stringValue;
    }

    public static String formatUS(Date date) {
        return DateHelper.formatUS(date, null);
    }

    public static String formatUS(Date date, String defaultValue) {
        String value = defaultValue;
        if (date != null) {
            value = STANDARD_US_DATE_FORMAT.format(date);
        }
        return value;
    }

    public static String formatUK(Date date) {
        return DateHelper.formatUK(date, null);
    }

    public static String formatUK(Date date, String defaultValue) {
        String value = defaultValue;
        if (date != null) {
            value = STANDARD_UK_DATE_FORMAT.format(date);
        }
        return value;
    }

    public static String format(Date date) {
        return DateHelper.format(date, null);
    }

    public static String format(Date date, String defaultValue) {
        String value = defaultValue;
        if (date != null) {
            value = STANDARD_FULL_DATE_FORMAT.format(date);
        }
        return value;
    }

    public static Calendar parse(String date) {
        return DateHelper.parse(date, DEFAULT_DATE_FORMATTERS);
    }

    public static Calendar parse(String date, TimeZone timeZone) {
        return DateHelper.parse(date, DEFAULT_DATE_FORMATTERS, null, timeZone);
    }

    public static Calendar parse(String date, List<SimpleDateFormat> dateFormatters) {
        return DateHelper.parse(date, dateFormatters, null);
    }

    public static Calendar parse(String date, List<SimpleDateFormat> dateFormatters, AtomicInteger indexOfValidFormatter) {
        return DateHelper.parse(date, dateFormatters, indexOfValidFormatter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar parse(String date, List<SimpleDateFormat> dateFormatters, AtomicInteger indexOfValidFormatter, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        List<SimpleDateFormat> formatters = dateFormatters == null || dateFormatters.size() <= 0 ? DEFAULT_DATE_FORMATTERS : dateFormatters;
        Calendar dateToReturn = null;
        AtomicInteger parseIndex = new AtomicInteger(-1);
        if (DateHelper.isValid(date, formatters, parseIndex)) {
            dateToReturn = DateHelper.getCalendarInstance();
            dateToReturn.clear();
            SimpleDateFormat formatter = formatters.get(parseIndex.get());
            if (timeZone != null) {
                dateToReturn.setTimeZone(timeZone);
                formatter = new SimpleDateFormat(formatter.toPattern());
                formatter.setTimeZone(timeZone);
            }
            SimpleDateFormat simpleDateFormat = formatter;
            synchronized (simpleDateFormat) {
                dateToReturn.setTime(formatter.parse(date, new ParsePosition(0)));
            }
        }
        if (indexOfValidFormatter != null) {
            indexOfValidFormatter.set(parseIndex.get());
        }
        return dateToReturn;
    }

    public static Calendar parseSimple(String date) {
        if (date != null) {
            String work = date.trim();
            StringTokenizer tokenizer = new StringTokenizer(work, "-/.");
            String strMonth = tokenizer.nextToken();
            String strDay = tokenizer.nextToken();
            String strYear = tokenizer.nextToken();
            int month = Integer.parseInt(strMonth) - 1;
            int day = Integer.parseInt(strDay);
            int year = Integer.parseInt(strYear);
            if (year < 100) {
                year = year > 50 ? (year += 1900) : (year += 2000);
            }
            Calendar cal = DateHelper.getCalendarInstance();
            cal.clear();
            cal.set(year, month, day);
            return cal;
        }
        return null;
    }

    public static int getDayOfWeek(String day) {
        if (day != null) {
            if (day.equalsIgnoreCase("monday")) {
                return 2;
            }
            if (day.equalsIgnoreCase("tuesday")) {
                return 3;
            }
            if (day.equalsIgnoreCase("wednesday")) {
                return 4;
            }
            if (day.equalsIgnoreCase("thursday")) {
                return 5;
            }
            if (day.equalsIgnoreCase("friday")) {
                return 6;
            }
            if (day.equalsIgnoreCase("saturday")) {
                return 7;
            }
            if (day.equalsIgnoreCase("sunday")) {
                return 1;
            }
        }
        return -1;
    }

    public static String getDayOfWeek(int day) {
        switch (day) {
            case 2: {
                return "Monday";
            }
            case 3: {
                return "Tuesday";
            }
            case 4: {
                return "Wednesday";
            }
            case 5: {
                return "Thursday";
            }
            case 6: {
                return "Friday";
            }
            case 7: {
                return "Saturday";
            }
            case 1: {
                return "Sunday";
            }
        }
        return null;
    }

    public static boolean isWeekday(Calendar cal) {
        return !DateHelper.isWeekend(cal);
    }

    public static boolean isWeekend(Calendar cal) {
        int day = cal.get(7);
        return day == 7 || day == 1;
    }

    public static Date getFirstSpecifiedDayOfWeekInMonth(int dayOfWeek) {
        return DateHelper.getFirstSpecifiedDayOfWeekInMonth(dayOfWeek, new Date());
    }

    public static Date getFirstSpecifiedDayOfWeekInMonth(int dayOfWeek, Date date) {
        return DateHelper.getFirstSpecifiedDayOfWeekInSpecifiedPeriod(5, dayOfWeek, date);
    }

    public static Date getFirstSpecifiedDayOfWeekInYear(int dayOfWeek) {
        return DateHelper.getFirstSpecifiedDayOfWeekInYear(dayOfWeek, new Date());
    }

    public static Date getFirstSpecifiedDayOfWeekInYear(int dayOfWeek, Date date) {
        return DateHelper.getFirstSpecifiedDayOfWeekInSpecifiedPeriod(6, dayOfWeek, date);
    }

    public static Date getFirstSpecifiedDayOfWeekInSpecifiedPeriod(int dayOfMonthOrYear, int dayOfWeek, Date date) {
        Calendar newCal = DateHelper.getCalendarInstance();
        newCal.setTime(date);
        newCal.set(dayOfMonthOrYear, 1);
        int currentDayOfWeek = newCal.get(7);
        int offset = dayOfWeek - currentDayOfWeek;
        if (currentDayOfWeek > dayOfWeek) {
            offset += 7;
        }
        newCal.add(dayOfMonthOrYear, offset);
        return newCal.getTime();
    }

    public static Calendar getCalendarInstance() {
        return DateHelper.getCalendarInstance(System.currentTimeMillis());
    }

    public static Calendar getCalendarInstance(long datetime) {
        Calendar cal = (Calendar)CALENDAR_INSTANCE.clone();
        cal.setTimeInMillis(datetime);
        return cal;
    }

    private DateHelper() {
    }
}

