/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import com.techempower.helper.NumberHelper;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class ThrowableHelper {
    public static String getStackTrace() {
        return ThrowableHelper.getStackTrace(Integer.MAX_VALUE);
    }

    public static String getStackTrace(int elements) {
        StringBuilder trace = new StringBuilder(2000);
        StackTraceElement[] traceElements = Thread.currentThread().getStackTrace();
        int elementCount = NumberHelper.boundInteger(elements, 1, Integer.MAX_VALUE);
        int endIndex = Math.min(traceElements.length - 1, elementCount + 1);
        int i = 2;
        while (i <= endIndex) {
            StackTraceElement element = traceElements[i];
            trace.append("at " + element.getClassName() + "." + element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")\n");
            ++i;
        }
        return trace.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        return ThrowableHelper.convertStackTraceToString(throwable);
    }

    public static String convertStackTraceToString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }

    private ThrowableHelper() {
    }
}

