/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.js;

import com.techempower.js.Visitor;
import com.techempower.js.VisitorFactory;
import java.util.Enumeration;

enum EnumerationVisitorFactory implements VisitorFactory<Object>
{
    INSTANCE;


    @Override
    public Visitor visitor(Object object) {
        if (!(object instanceof Enumeration)) {
            throw new IllegalArgumentException("Argument is not an Enumeration.");
        }
        return new EnumerationVisitor((Enumeration)object);
    }

    private static final class EnumerationVisitor<E>
    implements Visitor {
        private final Enumeration<E> enumeration;
        private E value;

        private EnumerationVisitor(Enumeration<E> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void next() {
            this.value = this.enumeration.nextElement();
        }

        @Override
        public Object value() {
            return this.value;
        }
    }
}

