/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.js;

import com.techempower.js.JavaScriptError;
import com.techempower.js.Visitor;
import com.techempower.js.VisitorFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReflectiveVisitorFactory<T>
implements VisitorFactory<T> {
    private final List<String> names;
    private final List<Method> methods;

    public ReflectiveVisitorFactory(Class<T> clazz, String ... namesAndMethods) {
        int size = namesAndMethods.length / 2;
        ArrayList<String> newNames = new ArrayList<String>(size);
        ArrayList<Method> newMethods = new ArrayList<Method>(size);
        int i = 0;
        while (i < size) {
            newNames.add(namesAndMethods[2 * i]);
            String method = namesAndMethods[2 * i + 1];
            try {
                newMethods.add(clazz.getMethod(method, new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("NoSuchMethodException for class " + clazz.getName() + " and method " + method + ".", e);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("SecurityException for class " + clazz.getName() + " and method " + method + ".", e);
            }
            ++i;
        }
        this.names = Collections.unmodifiableList(newNames);
        this.methods = Collections.unmodifiableList(newMethods);
    }

    @Override
    public Visitor visitor(T object) {
        return new ReflectiveVisitor(object);
    }

    final class ReflectiveVisitor
    implements Visitor {
        private final T object;
        private int index = -1;

        private ReflectiveVisitor(T object) {
            this.object = object;
        }

        @Override
        public boolean hasNext() {
            return this.index < ReflectiveVisitorFactory.this.names.size() - 1;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public String name() {
            return (String)ReflectiveVisitorFactory.this.names.get(this.index);
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public Object value() {
            try {
                return ((Method)ReflectiveVisitorFactory.this.methods.get(this.index)).invoke(this.object, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JavaScriptError("ReflectiveVisitor could not access method.", e);
            }
        }
    }
}

