/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.log;

import com.techempower.TechEmpowerApplication;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import com.techempower.helper.ThrowableHelper;
import com.techempower.log.LogListener;
import com.techempower.util.UtilityConstants;
import java.util.Calendar;

public abstract class AbstractLogListener
implements LogListener {
    private final TechEmpowerApplication application;
    private int debugThreshold = 0;
    private long endOfDay = DateHelper.getEndOfDay().getTimeInMillis();
    private long nextSecond = 0L;
    private String fullTimestamp = null;
    private String briefTimestamp = null;
    private final Calendar cal = DateHelper.getCalendarInstance();

    public AbstractLogListener(TechEmpowerApplication application) {
        this.application = application;
    }

    protected TechEmpowerApplication getApplication() {
        return this.application;
    }

    @Override
    public void debug(String componentCode, String debugString, int debugLevel) {
        this.log(componentCode, debugString, debugLevel);
    }

    @Override
    public void debug(String debugString, int debugLevel) {
        this.log("none", debugString, debugLevel);
    }

    @Override
    public void debug(String debugString, int debugLevel, Exception exc) {
        this.log("none", String.valueOf(debugString) + ThrowableHelper.convertStackTraceToString(exc), debugLevel);
    }

    @Override
    public void debug(String debugString, Exception exc) {
        this.log("none", String.valueOf(debugString) + ThrowableHelper.convertStackTraceToString(exc), 50);
    }

    @Override
    public void debug(String componentCode, String debugString) {
        this.log(componentCode, debugString, 50);
    }

    @Override
    public void debug(String debugString) {
        this.log("none", debugString, 50);
    }

    @Override
    public void assertion(String componentCode, boolean eval, String debugString, int debugLevel) {
        if (debugLevel >= this.getDebugThreshold() && !eval) {
            this.log(componentCode, debugString);
        }
    }

    @Override
    public void assertion(String componentCode, boolean eval, String logString) {
        this.assertion(componentCode, eval, logString, 50);
    }

    @Override
    public void assertion(boolean eval, String logString, int debugLevel) {
        this.assertion("none", eval, logString, debugLevel);
    }

    @Override
    public void assertion(boolean eval, String logString) {
        this.assertion("none", eval, logString, 50);
    }

    @Override
    public void log(String componentCode, String logString) {
        this.log(componentCode, logString, 50);
    }

    @Override
    public void log(String componentCode, String logString, int debugLevel) {
    }

    @Override
    public void log(String logString, int debugLevel) {
        this.log("none", logString, debugLevel);
    }

    @Override
    public void log(String logString) {
        this.log("none", logString, 50);
    }

    protected void computeTimestamps() {
        long now = System.currentTimeMillis();
        if (now > this.nextSecond) {
            long millis = now % 1000L;
            this.nextSecond = now - millis + 1000L;
            this.cal.setTimeInMillis(now);
            this.fullTimestamp = this.generateFullTimestamp();
            this.briefTimestamp = this.generateBriefTimestamp();
        }
    }

    protected String getFullTimestamp() {
        return this.fullTimestamp;
    }

    protected String getBriefTimestamp() {
        return this.briefTimestamp;
    }

    protected String generateFullTimestamp() {
        StringBuilder buffer = new StringBuilder(20);
        buffer.append(StringHelper.padZero(this.cal.get(5), 2));
        buffer.append(UtilityConstants.MONTH_NAMES_ABBREVIATED[this.cal.get(2)]);
        buffer.append(StringHelper.padZero(this.cal.get(1), 2));
        buffer.append(' ');
        buffer.append(StringHelper.padZero(this.cal.get(11), 2));
        buffer.append(':');
        buffer.append(StringHelper.padZero(this.cal.get(12), 2));
        buffer.append(':');
        buffer.append(StringHelper.padZero(this.cal.get(13), 2));
        return buffer.toString();
    }

    protected String generateBriefTimestamp() {
        StringBuilder buffer = new StringBuilder(8);
        buffer.append(StringHelper.padZero(this.cal.get(11), 2));
        buffer.append(':');
        buffer.append(StringHelper.padZero(this.cal.get(12), 2));
        buffer.append(':');
        buffer.append(StringHelper.padZero(this.cal.get(13), 2));
        return buffer.toString();
    }

    @Override
    public void setDebugThreshold(int d) {
        this.debugThreshold = d;
    }

    @Override
    public int getDebugThreshold() {
        return this.debugThreshold;
    }

    public boolean pastEndOfDay() {
        if (System.currentTimeMillis() > this.endOfDay) {
            this.endOfDay = DateHelper.getEndOfDay().getTimeInMillis();
            return true;
        }
        return false;
    }
}

