/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.log;

import com.techempower.helper.ThrowableHelper;
import com.techempower.log.Log;

public class ComponentLog {
    private final Log internalLog;
    private final String componentCode;

    public ComponentLog(Log log, String componentCode) {
        this.internalLog = log;
        this.componentCode = componentCode;
    }

    @Deprecated
    public void debug(String debugString, int debugLevel) {
        this.log(debugString, debugLevel);
    }

    @Deprecated
    public void debug(String debugString) {
        this.log(debugString);
    }

    @Deprecated
    public void debug(String debugString, int debugLevel, Throwable exception) {
        this.log(debugString, debugLevel, exception);
    }

    @Deprecated
    public void debug(String debugString, Throwable exception) {
        this.log(debugString, exception);
    }

    public void log(String logString, int debugLevel) {
        this.internalLog.log(this.componentCode, logString, debugLevel);
    }

    public void log(String logString) {
        this.internalLog.log(this.componentCode, logString);
    }

    public void log(String debugString, int debugLevel, Throwable exception) {
        this.log(String.valueOf(debugString) + ThrowableHelper.convertStackTraceToString(exception), debugLevel);
    }

    public void log(String debugString, Throwable exception) {
        this.log(String.valueOf(debugString) + ThrowableHelper.convertStackTraceToString(exception), 50);
    }

    public void assertion(boolean evalExpression, String debugString, int debugLevel) {
        this.internalLog.assertion(this.componentCode, evalExpression, debugString, debugLevel);
    }

    public void assertion(boolean evalExpression, String debugString) {
        this.internalLog.assertion(this.componentCode, evalExpression, debugString);
    }

    public Log getApplicationLog() {
        return this.internalLog;
    }

    public String getComponentCode() {
        return this.componentCode;
    }
}

