/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.log;

import com.techempower.TechEmpowerApplication;
import com.techempower.log.AbstractLogListener;

public class ConsoleLogListener
extends AbstractLogListener {
    public ConsoleLogListener(TechEmpowerApplication application, int threshold) {
        super(application);
        this.setDebugThreshold(threshold);
    }

    @Override
    public String getName() {
        return "Console Log";
    }

    @Override
    public void log(String componentCode, String debugString, int debugLevel) {
        if (debugLevel >= this.getDebugThreshold()) {
            this.debugToConsole(componentCode, debugString, debugLevel);
        }
    }

    protected void debugToConsole(String componentCode, String debugString) {
        this.debugToConsole(componentCode, debugString, 50);
    }

    protected void debugToConsole(String componentCode, String debugString, int debugLevel) {
        this.computeTimestamps();
        StringBuilder buffer = new StringBuilder(120);
        buffer.append(this.getApplication().getVersion().getProductCode());
        buffer.append(' ');
        buffer.append(this.getBriefTimestamp());
        buffer.append(' ');
        buffer.append(componentCode);
        buffer.append(": ");
        buffer.append(debugString);
        System.out.println(buffer.toString());
    }
}

