/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.log;

import com.techempower.TechEmpowerApplication;
import com.techempower.log.LogWriter;
import com.techempower.thread.EndableThread;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class LogWriterManager
extends EndableThread {
    private static final int INITIAL_SLEEP_MILLIS = 100;
    private static final int MINIMUM_SLEEP_MILLIS = 25;
    private static final int MAXIMUM_SLEEP_MILLIS = 150;
    private static final int SLEEP_ADJUSGMENT = 5;
    private static final long DEFAULT_LAST_ACCESS_THRESHOLD = 120000L;
    private final List<LogWriterDescriptor> logWriters = new CopyOnWriteArrayList<LogWriterDescriptor>();
    private long threshold = 120000L;

    public LogWriterManager(TechEmpowerApplication application) {
        super("Log Writer Manager (" + application.getVersion().getProductName() + ")", 100, 150, 25, 5);
    }

    public void addLogWriter(LogWriter logWriter, String description) {
        LogWriterDescriptor descriptor = new LogWriterDescriptor(logWriter, description);
        this.logWriters.add(descriptor);
    }

    public void removeLogWriter(LogWriter logWriter) {
        Iterator<LogWriterDescriptor> iter = this.logWriters.iterator();
        while (iter.hasNext()) {
            LogWriterDescriptor descriptor = iter.next();
            if (descriptor.logWriter != logWriter) continue;
            iter.remove();
        }
    }

    public void setIdleThreshold(long idleThreshold) {
        this.threshold = idleThreshold;
    }

    @Override
    public void run() {
        this.setStartTime();
        while (this.checkPause()) {
            this.simpleSleep();
            boolean anyActivity = false;
            long currentTime = System.currentTimeMillis();
            int i = 0;
            while (i < this.logWriters.size()) {
                LogWriterDescriptor descriptor = this.logWriters.get(i);
                boolean activity = descriptor.logWriter.flushFile();
                boolean bl = anyActivity = anyActivity || activity;
                if (activity) {
                    descriptor.lastAccess = currentTime;
                } else if (descriptor.logWriter.isOpen() && currentTime > descriptor.lastAccess + this.threshold) {
                    descriptor.logWriter.closeFile(String.valueOf(descriptor.description) + " inactive; closing file.");
                }
                ++i;
            }
            if (anyActivity) {
                this.setMinimumSleep();
                continue;
            }
            this.incrementSleep();
        }
    }

    @Override
    public String toString() {
        return "LogWriterManager [" + this.logWriters.size() + " LogWriters being watched]";
    }

    private static final class LogWriterDescriptor {
        private final LogWriter logWriter;
        private final String description;
        private long lastAccess;

        private LogWriterDescriptor(LogWriter logWriter, String description) {
            this.logWriter = logWriter;
            this.description = description;
            this.lastAccess = System.currentTimeMillis();
        }
    }
}

