/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.network;

import com.techempower.helper.DateHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import com.techempower.helper.ThrowableHelper;
import com.techempower.network.SiteDownException;
import com.techempower.util.SimpleEmailer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Date;

public class AppGoad {
    public static final String ARG_SECONDS_BETWEEN_TESTS = "--seconds-between-tests";
    public static final String ARG_SECONDS_ALLOWED_FOR_RESPONSE = "--seconds-allowed-for-response";
    public static final String ARG_TEST_FAILURES_TOLERATED = "--test-failures-tolerated";
    public static final String ARG_APP_SERVICE_NAME = "--app-service-name";
    public static final String ARG_SECONDS_BETWEEN_APP_STOP_AND_START = "--seconds-between-app-stop-and-start";
    public static final String ARG_SECONDS_ALLOWED_FOR_APP_STARTUP = "--seconds-allowed-for-app-startup";
    public static final String ARG_CHARS_TO_READ = "--chars-to-read";
    public static final int DEFAULT_SECONDS_BETWEEN_TESTS = 30;
    public static final int DEFAULT_SECONDS_ALLOWED_FOR_RESPONSE = 15;
    public static final int DEFAULT_TEST_FAILURES_TOLERATED = 4;
    public static final int DEFAULT_SECONDS_BETWEEN_APP_STOP_AND_START = 30;
    public static final int DEFAULT_SECONDS_ALLOWED_FOR_APP_STARTUP = 60;
    public static final int DEFAULT_CHARS_TO_READ = 500;
    public static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 30;
    public static final int DEFAULT_READ_TIMEOUT_SECONDS = 30;
    public static final String USAGE_MESSAGE = "Usage: java AppGoad [URL] [EXPECTED STRING] [RECIPIENT EMAIL ADDRESS] [OPTIONS]\nMonitors the given URL for the expected string and restarts the application server if the app goes down.\n\n  --seconds-between-tests\t\tSeconds to wait between test attempts.\n\t\t\t\t\tDefault is 30.\n  --seconds-allowed-for-response\tSeconds to allow response before\n\t\t\t\t\tdeclaring test a failure. Default is 15.\n  --test-failures-tolerated\t\tSuccessive test failures to tolerate\n\t\t\t\t\tbefore restarting app. Default is 4.\n  --app-service-name\t\t\tName of Windows service to restart when\n\t\t\t\t\tapp is determined to be down. Default\n\t\t\t\t\tis to monitor only.\n  --seconds-between-app-stop-and-start\tSeconds give app server between stop\n\t\t\t\t\tand start commands. Default is 30.\n  --seconds-allowed-for-app-startup\tSeconds to give the app to start before\n\t\t\t\t\tresuming testing. Default is 60.\n  --chars-to-read\t\t\tCharacters we need to read to find the\n\t\t\t\t\texpected string. Default is 500.\n  OPTIONS :\n\n  /Kill - Output 2 stack trace and Kill Windows Resin Process.\n\n";
    private String targetUrl = null;
    private String expectedString = null;
    private String recipientEmailAddress = null;
    private String appServiceName = null;
    private int msBetweenTests = 30000;
    private int msForResponse = 15000;
    private int msBetweenAppStopAndStart = 30000;
    private int msForAppStartup = 60000;
    private int testFailuresTolerated = 4;
    private int charsToRead = 500;
    private int msConnectTimeout = 30000;
    private int msReadTimeout = 30000;
    private String hostName = null;

    public static void main(String[] args) {
        AppGoad appGoad = new AppGoad();
        if (args.length == 1 && args[0].equals("/Kill")) {
            if (appGoad.isWindows()) {
                try {
                    AppGoad.debug("Kill Resin process " + appGoad.getWindowResinProcessID());
                    AppGoad.debug("Here are the stack trace dumps: ");
                    AppGoad.debug(appGoad.getWindowStackTrace());
                    AppGoad.debug(appGoad.getWindowStackTrace());
                    appGoad.killWindowsResinProcess();
                }
                catch (IOException ioe) {
                    AppGoad.debug("Exception :" + ioe);
                }
            } else {
                AppGoad.debug("/Kill option can only be used in Widnows.");
            }
            return;
        }
        if (args.length < 3) {
            AppGoad.debug(USAGE_MESSAGE);
            return;
        }
        appGoad.targetUrl = args[0];
        appGoad.expectedString = args[1];
        appGoad.recipientEmailAddress = args[2];
        AppGoad.debug("Target URL: \t" + appGoad.targetUrl);
        AppGoad.debug("Expecting:  \t" + appGoad.expectedString);
        AppGoad.debug("Notify:     \t" + appGoad.recipientEmailAddress);
        int i = 3;
        while (i + 1 < args.length) {
            String argName = args[i];
            String argVal = args[i + 1];
            if (StringHelper.equalsIgnoreCaseTrim(ARG_SECONDS_BETWEEN_TESTS, argName)) {
                appGoad.msBetweenTests = NumberHelper.parseInt(argVal, 30) * 1000;
                AppGoad.debug("--seconds-between-tests:  " + (long)appGoad.msBetweenTests / 1000L);
            } else if (StringHelper.equalsIgnoreCaseTrim(ARG_SECONDS_ALLOWED_FOR_RESPONSE, argName)) {
                appGoad.msForResponse = NumberHelper.parseInt(argVal, 15) * 1000;
                AppGoad.debug("--seconds-allowed-for-response:  " + (long)appGoad.msForResponse / 1000L);
            } else if (StringHelper.equalsIgnoreCaseTrim(ARG_TEST_FAILURES_TOLERATED, argName)) {
                appGoad.testFailuresTolerated = NumberHelper.parseInt(argVal, 4);
                AppGoad.debug("--test-failures-tolerated:  " + appGoad.testFailuresTolerated);
            } else if (StringHelper.equalsIgnoreCaseTrim(ARG_APP_SERVICE_NAME, argName)) {
                appGoad.appServiceName = StringHelper.emptyDefault(argVal, null);
                AppGoad.debug("--app-service-name:  " + appGoad.appServiceName);
            } else if (StringHelper.equalsIgnoreCaseTrim(ARG_SECONDS_BETWEEN_APP_STOP_AND_START, argName)) {
                appGoad.msBetweenAppStopAndStart = NumberHelper.parseInt(argVal, 30) * 1000;
                AppGoad.debug("--seconds-between-app-stop-and-start:  " + (long)appGoad.msBetweenAppStopAndStart / 1000L);
            } else if (StringHelper.equalsIgnoreCaseTrim(ARG_SECONDS_ALLOWED_FOR_APP_STARTUP, argName)) {
                appGoad.msForAppStartup = NumberHelper.parseInt(argVal, 60) * 1000;
                AppGoad.debug("--seconds-allowed-for-app-startup:  " + (long)appGoad.msForAppStartup / 1000L);
            } else if (StringHelper.equalsIgnoreCaseTrim(ARG_CHARS_TO_READ, argName)) {
                appGoad.charsToRead = NumberHelper.parseInt(argVal, 500);
                AppGoad.debug("--chars-to-read:  " + (long)appGoad.charsToRead / 1000L);
            }
            i += 2;
        }
        appGoad.execute();
    }

    /*
     * Unable to fully structure code
     */
    public void execute() {
        System.setProperty("sun.net.client.defaultConnectTimeout", "" + this.msConnectTimeout);
        System.setProperty("sun.net.client.defaultReadTimeout", "" + this.msReadTimeout);
        try {
            addr = InetAddress.getLocalHost();
            this.hostName = addr.getHostName();
        }
        catch (UnknownHostException addr) {
            // empty catch block
        }
        lastMainLoopExceptionNotificationTime = 0L;
        testFailures = new ArrayList<String>();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.msBetweenTests);
                    try {
                        if (!this.isSiteUp()) continue;
                        testFailures.clear();
                        continue;
                    }
                    catch (SiteDownException sde) {
                        testFailures.add(sde.getMessage());
                        AppGoad.debug(new Date() + " " + sde.getMessage());
                        msgBodyReasons = new StringBuilder();
                        ** for (s : testFailures)
                    }
lbl-1000:
                    // 1 sources

                    {
                        msgBodyReasons.append("\n- ");
                        msgBodyReasons.append(s);
                        continue;
                    }
lbl32:
                    // 1 sources

                    if (testFailures.size() >= this.testFailuresTolerated) {
                        this.restartApplication("App is considered down for reason" + StringHelper.pluralize(testFailures.size()) + ": \n" + msgBodyReasons);
                        testFailures.clear();
                        Thread.sleep(this.msForAppStartup);
                        continue;
                    }
                    this.sendEmail("Accumulated " + testFailures.size() + " test failure" + StringHelper.pluralize(testFailures.size()), "Sequential test failures so far:\t" + testFailures.size() + "\nTest failure threshold: \t\t" + this.testFailuresTolerated + "\n\nOnce the threshold is reached, the app will be regarded as down.\n" + msgBodyReasons);
                }
            }
            catch (Exception exc) {
                AppGoad.debug("::execute caught exception: " + exc);
                if (System.currentTimeMillis() - lastMainLoopExceptionNotificationTime <= 300000L) continue;
                lastMainLoopExceptionNotificationTime = System.currentTimeMillis();
                this.sendEmail("Main loop broke", "AppGoad caught exception: " + exc + ", stack trace " + ThrowableHelper.convertStackTraceToString(exc));
                continue;
            }
            break;
        }
    }

    public boolean isSiteUp() throws SiteDownException {
        InputStream urlInputStream = null;
        InputStreamReader reader = null;
        try {
            long startTime = System.currentTimeMillis();
            URL url = new URL(this.targetUrl);
            urlInputStream = url.openStream();
            reader = new InputStreamReader(urlInputStream, "UTF8");
            CharBuffer charBuffer = CharBuffer.allocate(this.charsToRead);
            reader.read(charBuffer);
            long timeTaken = System.currentTimeMillis() - startTime;
            if (timeTaken > (long)this.msForResponse) {
                throw new SiteDownException("Test failed because response time of " + timeTaken + "ms exceeds " + this.msForResponse + "ms limit.");
            }
            charBuffer.position(0);
            String content = charBuffer.toString();
            if (StringHelper.containsIgnoreCase(content, this.expectedString)) {
                AppGoad.debug("Site is up, response time: " + timeTaken + "ms.");
                return true;
            }
            try {
                throw new SiteDownException("Test failed because response did not contain \"" + this.expectedString + "\": " + content);
            }
            catch (SiteDownException exc) {
                throw exc;
            }
            catch (Exception exc) {
                throw new SiteDownException("Test failed because of exception: " + exc);
            }
        }
        finally {
            try {
                if (urlInputStream != null) {
                    urlInputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void restartApplication(String reason) throws IOException, InterruptedException {
        if (StringHelper.isNonEmpty(this.appServiceName)) {
            AppGoad.debug("Restarting application");
            this.sendEmail("Restarting service " + this.appServiceName, "Restarting application.\n" + reason);
            Runtime.getRuntime().exec("net stop " + this.appServiceName);
            Thread.sleep(this.msBetweenAppStopAndStart);
            Runtime.getRuntime().exec("net start " + this.appServiceName);
        } else {
            this.sendEmail("App needs to be restarted", "App needs to be restarted, but AppGoad is not configured to do so.\n" + reason);
            AppGoad.debug("Not restarting app because no app-service-name was provided.");
        }
    }

    public String getWindowResinProcessID() throws IOException {
        String[] jpsResult = null;
        String resinProcessID = null;
        String line = null;
        Process p = Runtime.getRuntime().exec("jps.exe");
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            while ((line = input.readLine()) != null) {
                jpsResult = line.split(" ");
                if (jpsResult.length <= 1 || jpsResult[1].toLowerCase().indexOf("resin") <= -1) continue;
                resinProcessID = jpsResult[0].trim();
            }
            return resinProcessID;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getWindowStackTrace() throws IOException {
        StringBuilder stackTrace = new StringBuilder();
        String line = null;
        Process p = Runtime.getRuntime().exec("jstack.exe " + this.getWindowResinProcessID());
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            while ((line = input.readLine()) != null) {
                stackTrace.append(line);
            }
            return stackTrace.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void killWindowsResinProcess() throws IOException {
        Runtime.getRuntime().exec("taskkill.exe /PID " + this.getWindowResinProcessID() + " /F");
    }

    public boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("window") > -1;
    }

    public void sendEmail(String subject, String body) {
        try {
            SimpleEmailer simpleEmailer = new SimpleEmailer("mail.techempower.com");
            simpleEmailer.sendEmail(null, null, "appgoad@techempower.com", this.recipientEmailAddress, "AppGoad on " + this.hostName + ": " + subject, "AppGoad on " + this.hostName + "\nTarget URL: " + this.targetUrl + "\n\n" + body);
        }
        catch (Exception exc) {
            AppGoad.debug("::sendEmail caught exception: " + exc);
        }
    }

    public static void debug(String msg) {
        System.out.println(String.valueOf(DateHelper.STANDARD_TECH_FORMAT.format(new Date())) + " " + msg);
    }
}

