/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public final class Ping {
    private static final int DEFAULT_TIMEOUT = 1000;
    private static final String DEFAULT_NAME = "eth0";
    private static volatile List<NetworkInterface> interfaces;
    private static volatile NetworkInterface defaultInterface;

    private static void initialize() {
        if (interfaces == null) {
            ArrayList<NetworkInterface> in = new ArrayList<NetworkInterface>();
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface currentInterface = enumeration.nextElement();
                    if (DEFAULT_NAME.equalsIgnoreCase(currentInterface.getName())) {
                        defaultInterface = currentInterface;
                    }
                    in.add(currentInterface);
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            interfaces = in;
        }
        if (defaultInterface == null && interfaces.size() > 0) {
            defaultInterface = interfaces.get(0);
        }
    }

    public static boolean ping(String ip) {
        return Ping.ping(Ping.getDefaultNetworkInterface(), ip, 1000);
    }

    public static boolean ping(String ip, int timeoutMilliseconds) {
        return Ping.ping(Ping.getDefaultNetworkInterface(), ip, timeoutMilliseconds);
    }

    public static boolean ping(NetworkInterface networkInterface, String ip) {
        return Ping.ping(networkInterface, ip, 1000);
    }

    public static boolean ping(NetworkInterface networkInterface, String ip, int timeoutMilliseconds) {
        try {
            Ping.initialize();
            InetAddress address = InetAddress.getByName(ip);
            return address.isReachable(networkInterface, 0, timeoutMilliseconds);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static List<NetworkInterface> getNetworkInterfaces() {
        Ping.initialize();
        return interfaces;
    }

    public static NetworkInterface getDefaultNetworkInterface() {
        Ping.initialize();
        return defaultInterface;
    }

    private Ping() {
    }
}

