/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

public abstract class TypeAdapter<F, T> {
    private final Type type;

    protected TypeAdapter() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new RuntimeException("Missing type parameter.");
        }
        this.type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    public abstract T write(F var1);

    public abstract F read(T var1);

    public Type getType() {
        return this.type;
    }

    public boolean appliesToType(Type typeToCheck) {
        Objects.requireNonNull(typeToCheck);
        return this.type.equals(typeToCheck);
    }

    public boolean appliesToField(Field field) {
        Objects.requireNonNull(field);
        return this.appliesToType(field.getGenericType());
    }

    public boolean appliesToGetMethod(Method getMethod) {
        Objects.requireNonNull(getMethod);
        return this.appliesToType(getMethod.getGenericReturnType());
    }

    public boolean appliesToSetMethod(Method setMethod) {
        Objects.requireNonNull(setMethod);
        return this.appliesToType(setMethod.getGenericParameterTypes()[0]);
    }
}

