/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.scheduler;

import com.techempower.helper.DateHelper;
import com.techempower.scheduler.ScheduledEvent;
import com.techempower.scheduler.Scheduler;
import com.techempower.util.Args;
import java.util.Calendar;

public abstract class DailyEvent
extends ScheduledEvent {
    private final int hour;
    private final int minute;

    public DailyEvent(String name, String description, int hour, int minute) {
        this.setName(name);
        this.setDescription(description);
        Args.intBound(minute, "minute", 0, 59);
        Args.intBound(hour, "hour", 0, 23);
        this.hour = hour;
        this.minute = minute;
    }

    @Override
    public long getDefaultScheduledTime() {
        return this.getNextRun().getTimeInMillis();
    }

    protected Calendar getNextRun() {
        Calendar cal = DateHelper.getCalendarInstance();
        cal.add(11, 1);
        while (cal.get(11) != this.hour) {
            cal.add(11, 1);
        }
        cal.set(12, this.minute);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    @Override
    public void execute(Scheduler scheduler) {
        this.doIt();
        Calendar nextRun = this.getNextRun();
        scheduler.scheduleEvent((ScheduledEvent)this, nextRun.getTimeInMillis());
    }

    protected abstract void doIt();
}

