/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.scheduler;

import com.techempower.helper.DateHelper;
import com.techempower.scheduler.ScheduledEvent;
import com.techempower.scheduler.Scheduler;
import com.techempower.util.Args;
import java.util.Calendar;

public abstract class MonthlyEvent
extends ScheduledEvent {
    private final int day;
    private final int hour;
    private final int minute;

    public MonthlyEvent(String name, String description, int day, int hour, int minute) {
        this.setName(name);
        this.setDescription(description);
        Args.intBound(day, "day", 0, 28);
        Args.intBound(minute, "minute", 0, 59);
        Args.intBound(hour, "hour", 0, 23);
        this.day = day;
        this.hour = hour;
        this.minute = minute;
    }

    @Override
    public long getDefaultScheduledTime() {
        return this.getNextRun().getTimeInMillis();
    }

    protected Calendar getNextRun() {
        Calendar cal = DateHelper.getStartOfDay();
        cal.add(5, 1);
        while (cal.get(5) != this.day) {
            cal.add(5, 1);
        }
        cal.set(11, this.hour);
        cal.set(12, this.minute);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    @Override
    public void execute(Scheduler scheduler) {
        this.doIt();
        Calendar nextRun = this.getNextRun();
        scheduler.scheduleEvent((ScheduledEvent)this, nextRun.getTimeInMillis());
    }

    protected abstract void doIt();
}

