/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.scheduler;

import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import com.techempower.scheduler.Scheduler;
import java.util.Calendar;
import java.util.Date;

public abstract class ScheduledEvent {
    public static final String COMPONENT_CODE = "sevt";
    private long scheduledTime = 0L;
    private int executions = 0;
    private long lastRunTime = 0L;
    private long lastCompleteTime = 0L;
    private long lastRunDuration = 0L;
    private boolean executing = false;
    private boolean enabled = true;
    private String name = "Event";
    private String description = null;

    public long getDefaultScheduledTime() {
        return this.getScheduledTime();
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public Date getScheduledTimeAsDate() {
        return new Date(this.getScheduledTime());
    }

    public String getScheduledTimeAsString() {
        return DateHelper.STANDARD_TECH_FORMAT.format(this.getScheduledTimeAsDate());
    }

    public void setScheduledTime(long time) {
        this.scheduledTime = time;
    }

    public void setScheduledTime(Date date) {
        this.scheduledTime = date.getTime();
    }

    public boolean requiresOwnThread() {
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setExecuting(boolean executing) {
        this.executing = executing;
        if (executing) {
            this.lastRunTime = System.currentTimeMillis();
            ++this.executions;
        } else {
            this.lastCompleteTime = System.currentTimeMillis();
            this.lastRunDuration = this.lastCompleteTime - this.lastRunTime;
        }
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public long getLastRunTime() {
        return this.lastRunTime;
    }

    public long getLastCompleteTime() {
        return this.lastCompleteTime;
    }

    public long getLastRunDuration() {
        return this.lastRunDuration;
    }

    public int getExecutions() {
        return this.executions;
    }

    public void reschedule(Scheduler scheduler, int calendarField, int delta) {
        Calendar newEventTime = DateHelper.getCalendarInstance(this.getScheduledTime());
        newEventTime.add(calendarField, delta);
        scheduler.scheduleEvent(this, newEventTime.getTime());
    }

    public void execute(Scheduler scheduler) {
        scheduler.removeEvent(this);
    }

    public void execute(Scheduler scheduler, boolean onDemandExection) {
        this.execute(scheduler);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        if (StringHelper.isEmpty(this.description)) {
            return this.getName();
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "[" + this.getName() + ": " + DateHelper.STANDARD_SQL_FORMAT.format(new Date(this.scheduledTime)) + (this.isEnabled() ? "" : " (disabled)") + "]";
    }
}

