/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.scheduler;

import com.techempower.log.ComponentLog;
import com.techempower.scheduler.Scheduler;
import com.techempower.thread.EndableThread;

public class SchedulerThread
extends EndableThread {
    public static final String COMPONENT_CODE = "sthr";
    private final Scheduler scheduler;
    private final ComponentLog log;
    private long nextCheck;

    public SchedulerThread(Scheduler scheduler) {
        super("Scheduler Thread (" + scheduler.getApplication().getVersion().getProductName() + ")");
        this.scheduler = scheduler;
        this.log = scheduler.getApplication().getLog(COMPONENT_CODE);
    }

    @Override
    public void run() {
        this.setStartTime();
        this.log.log("Scheduler thread started [" + this.scheduler.getApplication().getVersion().getProductName() + "; " + this.scheduler.hashCode() + "].");
        while (this.checkPause()) {
            this.scheduler.checkSchedule();
            this.nextCheck = System.currentTimeMillis() + this.scheduler.getSleepTime();
            this.simpleSleep(this.scheduler.getSleepTime());
        }
        this.log.log("Scheduler thread stopped [" + this.scheduler.getApplication().getVersion().getProductName() + "; " + this.scheduler.hashCode() + "].");
    }

    public long getNextCheckTime() {
        return this.nextCheck;
    }

    @Override
    public void setKeepRunning(boolean keepRunning) {
        super.setKeepRunning(keepRunning);
        if (!this.isRunning()) {
            this.log.log("Stop request received.");
        }
    }

    @Override
    public String toString() {
        return "SchedulerThread " + this.scheduler;
    }
}

