/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.security;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public class TokenProvider {
    private int capacity;
    private int tokenSize;
    private LinkedList<byte[]> tokens;
    private Random random;

    public TokenProvider(int capacity, int tokenSize) {
        if (capacity < 1) {
            throw new IllegalArgumentException("The capacity must be greater than zero.");
        }
        if (tokenSize < 1) {
            throw new IllegalArgumentException("The token size must be greater than zero.");
        }
        this.capacity = capacity;
        this.tokenSize = tokenSize;
        this.tokens = new LinkedList();
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            this.random = new Random();
        }
    }

    public synchronized byte[] next() {
        if (this.tokens.size() >= this.capacity) {
            this.tokens.removeLast();
        }
        byte[] token = new byte[this.tokenSize];
        this.random.nextBytes(token);
        this.tokens.addFirst(token);
        return token;
    }

    public synchronized boolean validate(byte[] token) {
        Iterator iter = this.tokens.iterator();
        while (iter.hasNext()) {
            if (!Arrays.equals(token, (byte[])iter.next())) continue;
            iter.remove();
            return true;
        }
        return false;
    }
}

