/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.util;

import com.techempower.TechEmpowerApplication;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class EnhancedProperties
extends Properties {
    private static final long serialVersionUID = 366163330L;
    public static final String MACRO_START = "${";
    public static final String MACRO_END = "}";
    private transient TechEmpowerApplication application;

    public EnhancedProperties(TechEmpowerApplication application) {
        this.setApplication(application);
    }

    public EnhancedProperties() {
    }

    public void setApplication(TechEmpowerApplication application) {
        this.application = application;
    }

    public TechEmpowerApplication getApplication() {
        return this.application;
    }

    public long getLongProperty(String name) {
        return this.getLongProperty(name, 0L);
    }

    public long getLongProperty(String name, long defaultValue) {
        long toReturn = defaultValue;
        try {
            String value = this.getProperty(name);
            if (value != null) {
                toReturn = Long.parseLong(value.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return toReturn;
    }

    public long getLongProperty(String name, long defaultValue, long minimum, long maximum) {
        long toReturn = defaultValue;
        try {
            String value = this.getProperty(name);
            if (value != null) {
                toReturn = NumberHelper.boundLong(Long.parseLong(value.trim()), minimum, maximum);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return toReturn;
    }

    public <T extends Enum<T>> T getEnumProperty(String name, Class<T> clazz, T defaultValue) {
        T toReturn = defaultValue;
        String value = this.getProperty(name);
        if (value != null) {
            toReturn = Enum.valueOf(clazz, value.trim().toUpperCase());
        }
        return toReturn;
    }

    public int getIntegerProperty(String name) {
        return this.getIntegerProperty(name, 0);
    }

    public int getIntegerProperty(String name, int defaultValue) {
        String value = this.getProperty(name);
        if (StringHelper.isNonEmpty(value)) {
            return NumberHelper.parseInt(value.trim(), defaultValue);
        }
        return defaultValue;
    }

    public int getIntegerProperty(String name, int defaultValue, int minimum, int maximum) {
        return NumberHelper.boundInteger(this.getIntegerProperty(name, defaultValue), minimum, maximum);
    }

    public double getDoubleProperty(String name) {
        return this.getDoubleProperty(name, 0.0);
    }

    public double getDoubleProperty(String name, double defaultValue) {
        double toReturn = defaultValue;
        try {
            String value = this.getProperty(name);
            if (value != null) {
                toReturn = Double.parseDouble(value.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return toReturn;
    }

    public float getFloatProperty(String name) {
        return this.getFloatProperty(name, 0.0f);
    }

    public float getFloatProperty(String name, float defaultValue) {
        float toReturn = defaultValue;
        try {
            String value = this.getProperty(name);
            if (value != null) {
                toReturn = Float.parseFloat(value.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return toReturn;
    }

    public boolean getYesNoProperty(String name) {
        return this.getYesNoProperty(name, false);
    }

    public boolean getYesNoProperty(String name, boolean defaultValue) {
        return StringHelper.parseBoolean(this.getProperty(name), defaultValue);
    }

    public String[] getArrayProperty(String name, String[] defaultArray) {
        String prop = this.getProperty(name);
        String[] toReturn = StringHelper.isNonEmpty(prop) ? prop.split("\\s*,\\s*") : defaultArray;
        return toReturn;
    }

    public String[] getArrayProperty(String name) {
        return this.getArrayProperty(name, new String[0]);
    }

    @Override
    public String getProperty(String name) {
        return this.macroExpand(super.getProperty(name));
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.macroExpand(super.getProperty(key, defaultValue));
    }

    private String macroExpand(String value) {
        String expandedValue = value;
        if (expandedValue != null) {
            int markerLocation = expandedValue.indexOf(MACRO_START);
            while (markerLocation >= 0) {
                int endLocation = expandedValue.indexOf(MACRO_END, markerLocation);
                if (endLocation >= 0) {
                    String macroName = expandedValue.substring(markerLocation + MACRO_START.length(), endLocation);
                    String macroValue = this.getProperty(macroName, "");
                    expandedValue = String.valueOf(expandedValue.substring(0, markerLocation)) + macroValue + expandedValue.substring(endLocation + 1);
                }
                markerLocation = expandedValue.indexOf(MACRO_START);
            }
        }
        return expandedValue;
    }

    public boolean isDefined(String propertyName) {
        return this.getProperty(propertyName) != null;
    }

    public void loadFromUrlCommandString(String s) {
        try {
            String s1 = URLDecoder.decode(s, StandardCharsets.UTF_8.name());
            StringTokenizer stringtokenizer = new StringTokenizer(s1, "?&");
            while (stringtokenizer.hasMoreElements()) {
                String s2 = stringtokenizer.nextToken();
                int i = s2.indexOf(61);
                if (i > 0) {
                    if (i == s2.length() - 1) {
                        this.put(s2.substring(0, i), "");
                        continue;
                    }
                    this.put(s2.substring(0, i), s2.substring(i + 1));
                    continue;
                }
                if (i != -1) continue;
                this.put(s2, "");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public Focus focus(String prefix) {
        return new Focus(prefix);
    }

    public EnhancedProperties extractProperties(String prefix) {
        return this.extractProperties(prefix, false);
    }

    public EnhancedProperties extractProperties(String prefix, boolean strip) {
        EnhancedProperties extractedProps = new EnhancedProperties();
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!StringHelper.startsWithIgnoreCase(key, prefix) || key.length() <= prefix.length()) continue;
            if (strip) {
                key = key.substring(prefix.length());
            }
            extractedProps.setProperty(key, value);
        }
        return extractedProps;
    }

    public void mergeProperties(EnhancedProperties props) {
        this.mergeProperties(props, "");
    }

    public void mergeProperties(EnhancedProperties props, String prefix) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.setProperty(String.valueOf(prefix) + key, value);
        }
    }

    public class Focus {
        private final String prefix;

        private Focus(String prefix) {
            this.prefix = prefix;
        }

        public String name(String name) {
            return String.valueOf(this.prefix) + name;
        }

        public String getProperty(String name) {
            return EnhancedProperties.this.getProperty(this.name(name));
        }

        public String getProperty(String name, String defaultValue) {
            return EnhancedProperties.this.getProperty(this.name(name), defaultValue);
        }

        public boolean getYesNoProperty(String name, boolean defaultValue) {
            return EnhancedProperties.this.getYesNoProperty(this.name(name), defaultValue);
        }

        public int getIntegerProperty(String name, int defaultValue) {
            return EnhancedProperties.this.getIntegerProperty(this.name(name), defaultValue);
        }

        public int getIntegerProperty(String name, int defaultValue, int minimum, int maximum) {
            return EnhancedProperties.this.getIntegerProperty(this.name(name), defaultValue, minimum, maximum);
        }

        public long getLongProperty(String name, long defaultValue) {
            return EnhancedProperties.this.getLongProperty(this.name(name), defaultValue);
        }

        public long getLongProperty(String name, long defaultValue, long minimum, long maximum) {
            return EnhancedProperties.this.getLongProperty(this.name(name), defaultValue, minimum, maximum);
        }

        public <T extends Enum<T>> T getEnumProperty(String name, Class<T> clazz, T defaultValue) {
            return EnhancedProperties.this.getEnumProperty(this.name(name), clazz, defaultValue);
        }
    }
}

