/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.util;

import com.techempower.helper.StringHelper;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SimpleEmailer {
    private String mailServer;

    public SimpleEmailer(String mailServer) {
        this.mailServer = mailServer;
    }

    public boolean sendEmail(String username, String password, String from, String to, String subject, String body, Map<String, Object> macros) {
        String messageBody = StringHelper.macroExpand(macros, body);
        String messageSubject = StringHelper.macroExpand(macros, subject);
        return this.sendEmail(username, password, from, to, messageSubject, messageBody);
    }

    public boolean sendEmail(String username, String password, String from, String to, String subject, String body) {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.mailServer);
        props.put("mail.smtp.connectiontimeout", "60000");
        props.put("mail.smtp.timeout", "60000");
        EmailAuthenticator authenticator = null;
        if (StringHelper.isNonEmpty(username)) {
            authenticator = new EmailAuthenticator(username, password);
            props.put("mail.smtp.auth", "true");
        }
        Session mailSession = Session.getInstance((Properties)props, authenticator);
        try {
            MimeMessage message = new MimeMessage(mailSession);
            message.addFrom((Address[])InternetAddress.parse((String)from, (boolean)false));
            message.setReplyTo((Address[])InternetAddress.parse((String)from, (boolean)false));
            message.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
            message.setSubject(subject);
            message.setContent((Object)body, "text/plain");
            try {
                Transport.send((Message)message);
            }
            catch (Exception exc) {
                SimpleEmailer.log("Exception during JavaMail transport: " + exc);
                return false;
            }
        }
        catch (Exception exc) {
            SimpleEmailer.log("Exception prior to JavaMail transport:" + exc);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length >= 5) {
            String server = args[0];
            String from = args[1];
            String to = args[2];
            String subject = args[3];
            String file = args[4];
            int macrosStart = 5;
            String username = "";
            String password = "";
            if (args.length >= 7 && "-u".equals(args[5])) {
                username = args[6];
                macrosStart = 7;
            }
            if (args.length >= 9 && "-p".equals(args[7])) {
                password = args[8];
                macrosStart = 9;
            }
            SimpleEmailer.log("Srv:  " + server);
            SimpleEmailer.log("From: " + from);
            SimpleEmailer.log("To:   " + to);
            SimpleEmailer.log("Subj: " + subject);
            SimpleEmailer.log("Body: " + file);
            if (StringHelper.isNonEmpty(username)) {
                SimpleEmailer.log("User: " + username);
            }
            if (StringHelper.isNonEmpty(password)) {
                SimpleEmailer.log("Pass: Provided");
            }
            HashMap<String, Object> macros = new HashMap<String, Object>();
            int i = macrosStart;
            while (i < args.length) {
                int index = i - macrosStart + 1;
                if (index < 10) {
                    macros.put("$0" + index, args[i]);
                    SimpleEmailer.log("$0" + index + ":  " + args[i]);
                } else {
                    macros.put("$" + index, args[i]);
                    SimpleEmailer.log("$" + index + ":  " + args[i]);
                }
                ++i;
            }
            Date now = new Date();
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            macros.put("$time", timeFormat.format(now));
            macros.put("$date", dateFormat.format(now));
            String body = "";
            try {
                Throwable throwable = null;
                Object var15_19 = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    byte[] buffer = new byte[fis.available()];
                    fis.read(buffer, 0, buffer.length);
                    body = new String(buffer);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioexc) {
                SimpleEmailer.log("IOException: " + ioexc);
            }
            SimpleEmailer emailer = new SimpleEmailer(server);
            emailer.sendEmail(username, password, from, to, subject, body, macros);
        } else {
            SimpleEmailer.log("SimpleEmailer usage");
            SimpleEmailer.log("SimpleEmailer.bat mailserver from to subject templatefile [-u username] [-p password] macro1..n");
        }
    }

    public static void log(String logString) {
        System.out.println("SmEm: " + logString);
    }

    static class EmailAuthenticator
    extends Authenticator {
        private final PasswordAuthentication pauth;

        public EmailAuthenticator(String username, String password) {
            this.pauth = new PasswordAuthentication(username, password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.pauth;
        }
    }
}

