/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.zipcode;

import com.techempower.util.EnhancedProperties;
import com.techempower.zipcode.ZipCodeRange;

public class ZipCodeManager {
    public static final String COMPONENT_CODE = "zipm";
    public static final int DEFAULT_RADIUS_OF_EARTH = 3956;
    public static final double DEFAULT_DELTA_DIVISOR = 1.0;
    public static final String DEFAULT_LATITUDE = "ZipLat";
    public static final String DEFAULT_LONGITUDE = "ZipLon";
    private int radiusOfEarth = 3956;
    private double deltaDivisor = 1.0;
    private String latitudeColumn = "ZipLat";
    private String longitudeColumn = "ZipLon";

    public void configure(EnhancedProperties props) {
        this.radiusOfEarth = props.getIntegerProperty("zip.RadiusOfEarth", this.radiusOfEarth);
        this.deltaDivisor = props.getDoubleProperty("zip.DeltaDivisor", this.deltaDivisor);
        this.latitudeColumn = props.getProperty("zip.LatitudeColumn", this.latitudeColumn);
        this.longitudeColumn = props.getProperty("zip.LongitudeColumn", this.longitudeColumn);
    }

    public ZipCodeRange getZipCodeRange(double latitudeMin, double latitudeMax, double longitudeMin, double longitudeMax) {
        return new ZipCodeRange(this, latitudeMin, latitudeMax, longitudeMin, longitudeMax);
    }

    public ZipCodeRange getZipCodeRange(double sourceLon, double sourceLat, int distanceInMiles) {
        return new ZipCodeRange(this, sourceLon, sourceLat, distanceInMiles);
    }

    public int getRadiusOfEarth() {
        return this.radiusOfEarth;
    }

    public double getDeltaDivisor() {
        return this.deltaDivisor;
    }

    public String getLongitudeColumn() {
        return this.longitudeColumn;
    }

    public String getLatitudeColumn() {
        return this.latitudeColumn;
    }
}

