/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    int objectGraphLevel;
    private HashMap<Object, Object> map;
    private HashMap<Object, Object> tempMap;
    private final ArrayList<ByteBuffer> buffers = new ArrayList(2);
    private int remoteEntityID;
    private final SerializerKey tempKey = new SerializerKey(null, null);
    private byte[] byteArray;
    private char[] charArray = new char[256];
    private int[] intArray;

    public ByteBuffer getBuffer(int n) {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = byteBuffer = this.buffers.isEmpty() ? null : this.buffers.get(0);
        if (byteBuffer == null || byteBuffer.capacity() < n) {
            byteBuffer = ByteBuffer.allocate(n);
        } else {
            byteBuffer.clear();
        }
        return byteBuffer;
    }

    public ArrayList<ByteBuffer> getBuffers(int n, int n2) {
        int n3;
        int n4 = Math.min(n, this.buffers.size());
        for (n3 = 0; n3 < n4; ++n3) {
            ByteBuffer byteBuffer = this.buffers.get(n3);
            if (byteBuffer.capacity() >= n2) continue;
            this.buffers.set(n3, ByteBuffer.allocate(n2));
        }
        while (n3 < n) {
            this.buffers.add(ByteBuffer.allocate(n2));
            ++n3;
        }
        return this.buffers;
    }

    public char[] getCharArray(int n) {
        if (this.charArray.length < n) {
            this.charArray = new char[n];
        }
        return this.charArray;
    }

    public int[] getIntArray(int n) {
        if (this.intArray == null || this.intArray.length < n) {
            this.intArray = new int[n];
        }
        return this.intArray;
    }

    public byte[] getByteArray(int n) {
        if (this.byteArray == null || this.byteArray.length < n) {
            this.byteArray = new byte[n];
        }
        return this.byteArray;
    }

    public void put(String string, Object object) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(string, object);
    }

    public Object get(String string) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        return this.map.get(string);
    }

    public void put(Serializer serializer, String string, Object object) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(new SerializerKey(serializer, string), object);
    }

    public Object get(Serializer serializer, String string) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.tempKey.serializer = serializer;
        this.tempKey.key = string;
        return this.map.get(this.tempKey);
    }

    public void putTemp(String string, Object object) {
        if (this.tempMap == null) {
            this.tempMap = new HashMap();
        }
        this.tempMap.put(string, object);
    }

    public Object getTemp(String string) {
        if (this.tempMap == null) {
            this.tempMap = new HashMap();
        }
        return this.tempMap.get(string);
    }

    public void putTemp(Serializer serializer, String string, Object object) {
        if (this.tempMap == null) {
            this.tempMap = new HashMap();
        }
        this.tempMap.put(new SerializerKey(serializer, string), object);
    }

    public Object getTemp(Serializer serializer, String string) {
        if (this.tempMap == null) {
            this.tempMap = new HashMap();
        }
        this.tempKey.serializer = serializer;
        this.tempKey.key = string;
        return this.tempMap.get(this.tempKey);
    }

    public void reset() {
        if (this.tempMap != null) {
            this.tempMap.clear();
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Context reset.");
        }
    }

    public int getRemoteEntityID() {
        return this.remoteEntityID;
    }

    public void setRemoteEntityID(int n) {
        this.remoteEntityID = n;
    }

    private static class SerializerKey {
        Serializer serializer;
        String key;

        public SerializerKey(Serializer serializer, String string) {
            this.serializer = serializer;
            this.key = string;
        }

        public int hashCode() {
            int n = 31 + this.key.hashCode();
            n = 31 * n + this.serializer.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SerializerKey serializerKey = (SerializerKey)object;
            if (!this.key.equals(serializerKey.key)) {
                return false;
            }
            return this.serializer.equals(serializerKey.serializer);
        }
    }
}

