/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectBuffer {
    private Kryo kryo;
    private final int maxCapacity;
    private ByteBuffer buffer;
    private byte[] bytes;

    public ObjectBuffer(Kryo kryo) {
        this(kryo, 2048, 16384);
    }

    public ObjectBuffer(Kryo kryo, int n) {
        this(kryo, n, n);
    }

    public ObjectBuffer(Kryo kryo, int n, int n2) {
        this.kryo = kryo;
        this.buffer = ByteBuffer.allocate(n);
        this.bytes = this.buffer.array();
        this.maxCapacity = n2;
    }

    public void setKryo(Kryo kryo) {
        this.kryo = kryo;
    }

    private void readToBuffer(InputStream inputStream, int n) {
        if (n == -1) {
            n = Integer.MAX_VALUE;
        }
        try {
            int n2;
            int n3 = 0;
            while (n3 < n && (n2 = inputStream.read(this.bytes, n3, Math.min(this.bytes.length - n3, n - n3))) != -1) {
                if ((n3 += n2) != this.bytes.length || this.resizeBuffer(true)) continue;
                throw new SerializationException("Buffer limit exceeded: " + this.maxCapacity);
            }
            this.buffer.position(0);
            this.buffer.limit(n3);
        }
        catch (IOException iOException) {
            throw new SerializationException("Error reading object bytes.", iOException);
        }
    }

    public Object readClassAndObject(InputStream inputStream) {
        this.readToBuffer(inputStream, -1);
        return this.kryo.readClassAndObject(this.buffer);
    }

    public Object readClassAndObject(InputStream inputStream, int n) {
        this.readToBuffer(inputStream, n);
        return this.kryo.readClassAndObject(this.buffer);
    }

    public <T> T readObject(InputStream inputStream, Class<T> clazz) {
        this.readToBuffer(inputStream, -1);
        return this.kryo.readObject(this.buffer, clazz);
    }

    public <T> T readObject(InputStream inputStream, int n, Class<T> clazz) {
        this.readToBuffer(inputStream, n);
        return this.kryo.readObject(this.buffer, clazz);
    }

    public <T> T readObjectData(InputStream inputStream, Class<T> clazz) {
        this.readToBuffer(inputStream, -1);
        return this.kryo.readObjectData(this.buffer, clazz);
    }

    public <T> T readObjectData(InputStream inputStream, int n, Class<T> clazz) {
        this.readToBuffer(inputStream, n);
        return this.kryo.readObjectData(this.buffer, clazz);
    }

    public void writeClassAndObject(OutputStream outputStream, Object object) {
        this.buffer.clear();
        while (true) {
            try {
                this.kryo.writeClassAndObject(this.buffer, object);
            }
            catch (SerializationException serializationException) {
                if (!serializationException.causedBy(BufferOverflowException.class)) {
                    throw serializationException;
                }
                if (!this.resizeBuffer(false)) {
                    throw new SerializationException("Buffer limit exceeded serializing object of type: " + object.getClass().getName(), serializationException);
                }
                Kryo.getContext().reset();
                continue;
            }
            break;
        }
        this.writeToStream(outputStream);
    }

    public void writeObject(OutputStream outputStream, Object object) {
        this.buffer.clear();
        while (true) {
            try {
                this.kryo.writeObject(this.buffer, object);
            }
            catch (SerializationException serializationException) {
                if (!serializationException.causedBy(BufferOverflowException.class)) {
                    throw serializationException;
                }
                if (!this.resizeBuffer(false)) {
                    throw new SerializationException("Buffer limit exceeded serializing object of type: " + object.getClass().getName(), serializationException);
                }
                Kryo.getContext().reset();
                continue;
            }
            break;
        }
        this.writeToStream(outputStream);
    }

    public void writeObjectData(OutputStream outputStream, Object object) {
        this.buffer.clear();
        while (true) {
            try {
                this.kryo.writeObjectData(this.buffer, object);
            }
            catch (SerializationException serializationException) {
                if (!serializationException.causedBy(BufferOverflowException.class)) {
                    throw serializationException;
                }
                if (!this.resizeBuffer(false)) {
                    throw new SerializationException("Buffer limit exceeded serializing object of type: " + object.getClass().getName(), serializationException);
                }
                Kryo.getContext().reset();
                continue;
            }
            break;
        }
        this.writeToStream(outputStream);
    }

    private void writeToStream(OutputStream outputStream) {
        try {
            outputStream.write(this.bytes, 0, this.buffer.position());
        }
        catch (IOException iOException) {
            throw new SerializationException("Error writing object bytes.", iOException);
        }
    }

    public Object readClassAndObject(byte[] byArray) {
        return this.kryo.readClassAndObject(ByteBuffer.wrap(byArray));
    }

    public <T> T readObject(byte[] byArray, Class<T> clazz) {
        return this.kryo.readObject(ByteBuffer.wrap(byArray), clazz);
    }

    public <T> T readObjectData(byte[] byArray, Class<T> clazz) {
        return this.kryo.readObjectData(ByteBuffer.wrap(byArray), clazz);
    }

    public byte[] writeClassAndObject(Object object) {
        this.buffer.clear();
        while (true) {
            try {
                this.kryo.writeClassAndObject(this.buffer, object);
            }
            catch (SerializationException serializationException) {
                if (!serializationException.causedBy(BufferOverflowException.class)) {
                    throw serializationException;
                }
                if (!this.resizeBuffer(false)) {
                    throw new SerializationException("Buffer limit exceeded serializing object of type: " + object.getClass().getName(), serializationException);
                }
                Kryo.getContext().reset();
                continue;
            }
            break;
        }
        return this.writeToBytes();
    }

    public byte[] writeObject(Object object) {
        this.buffer.clear();
        while (true) {
            try {
                this.kryo.writeObject(this.buffer, object);
            }
            catch (SerializationException serializationException) {
                if (!serializationException.causedBy(BufferOverflowException.class)) {
                    throw serializationException;
                }
                if (!this.resizeBuffer(false)) {
                    throw new SerializationException("Buffer limit exceeded serializing object of type: " + object.getClass().getName(), serializationException);
                }
                Kryo.getContext().reset();
                continue;
            }
            break;
        }
        return this.writeToBytes();
    }

    public byte[] writeObjectData(Object object) {
        this.buffer.clear();
        while (true) {
            try {
                this.kryo.writeObjectData(this.buffer, object);
            }
            catch (SerializationException serializationException) {
                if (!serializationException.causedBy(BufferOverflowException.class)) {
                    throw serializationException;
                }
                if (!this.resizeBuffer(false)) {
                    throw new SerializationException("Buffer limit exceeded serializing object of type: " + object.getClass().getName(), serializationException);
                }
                Kryo.getContext().reset();
                continue;
            }
            break;
        }
        return this.writeToBytes();
    }

    private byte[] writeToBytes() {
        byte[] byArray = new byte[this.buffer.position()];
        System.arraycopy(this.bytes, 0, byArray, 0, byArray.length);
        return byArray;
    }

    private boolean resizeBuffer(boolean bl) {
        int n = this.buffer.capacity();
        if (n == this.maxCapacity) {
            return false;
        }
        int n2 = Math.min(this.maxCapacity, n * 2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byte[] byArray = byteBuffer.array();
        if (bl) {
            System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
        }
        this.buffer = byteBuffer;
        this.bytes = byArray;
        if (Log.DEBUG) {
            Log.debug("kryo", "Resized ObjectBuffer to: " + n2);
        }
        return true;
    }
}

