/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.minlog.Log;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializer
extends Serializer {
    static final Object[] noArgs = new Object[0];
    private final Kryo kryo;
    private CachedProperty[] properties;
    Object access;

    public BeanSerializer(Kryo kryo, Class clazz) {
        BeanInfo beanInfo;
        this.kryo = kryo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            throw new SerializationException("Error getting bean info.", introspectionException);
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        Arrays.sort(propertyDescriptorArray, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
                return propertyDescriptor.getName().compareTo(propertyDescriptor2.getName());
            }
        });
        ArrayList<CachedProperty> arrayList = new ArrayList<CachedProperty>(propertyDescriptorArray.length);
        for (PropertyDescriptor object : propertyDescriptorArray) {
            String string = object.getName();
            if (string.equals("class")) continue;
            Method method = object.getReadMethod();
            Method method2 = object.getWriteMethod();
            if (method == null || method2 == null) continue;
            Serializer serializer = null;
            Class<?> clazz2 = method.getReturnType();
            if (this.isFinal(clazz2)) {
                serializer = kryo.getRegisteredClass(clazz2).getSerializer();
            }
            CachedProperty cachedProperty = new CachedProperty();
            cachedProperty.name = string;
            cachedProperty.getMethod = method;
            cachedProperty.setMethod = method2;
            cachedProperty.serializer = serializer;
            cachedProperty.setMethodType = method2.getParameterTypes()[0];
            arrayList.add(cachedProperty);
        }
        this.properties = arrayList.toArray(new CachedProperty[arrayList.size()]);
        try {
            this.access = MethodAccess.get(clazz);
            for (CachedProperty cachedProperty : this.properties) {
                cachedProperty.getterAccessIndex = ((MethodAccess)this.access).getIndex(cachedProperty.getMethod.getName());
                cachedProperty.setterAccessIndex = ((MethodAccess)this.access).getIndex(cachedProperty.setMethod.getName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        Class<?> clazz = object.getClass();
        for (CachedProperty cachedProperty : this.properties) {
            Object object2;
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Writing property: " + cachedProperty + " (" + clazz.getName() + ")");
                }
                Object object3 = cachedProperty.get(object);
                object2 = cachedProperty.serializer;
                if (object2 != null) {
                    ((Serializer)object2).writeObject(byteBuffer, object3);
                    continue;
                }
                this.kryo.writeClassAndObject(byteBuffer, object3);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SerializationException("Error accessing getter method: " + cachedProperty + " (" + clazz.getName() + ")", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SerializationException("Error invoking getter method: " + cachedProperty + " (" + clazz.getName() + ")", invocationTargetException);
            }
            catch (SerializationException serializationException) {
                serializationException.addTrace(cachedProperty + " (" + clazz.getName() + ")");
                throw serializationException;
            }
            catch (RuntimeException runtimeException) {
                object2 = new SerializationException(runtimeException);
                ((SerializationException)object2).addTrace(cachedProperty + " (" + clazz.getName() + ")");
                throw object2;
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote bean: " + object);
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer byteBuffer, Class<T> clazz) {
        return this.readObjectData(this.newInstance(this.kryo, clazz), byteBuffer, clazz);
    }

    protected <T> T readObjectData(T t, ByteBuffer byteBuffer, Class<T> clazz) {
        for (CachedProperty cachedProperty : this.properties) {
            Object object;
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Reading property: " + cachedProperty + " (" + t.getClass() + ")");
                }
                Object object2 = (object = cachedProperty.serializer) != null ? ((Serializer)object).readObject(byteBuffer, cachedProperty.setMethodType) : this.kryo.readClassAndObject(byteBuffer);
                cachedProperty.set(t, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SerializationException("Error accessing setter method: " + cachedProperty + " (" + clazz.getName() + ")", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SerializationException("Error invoking setter method: " + cachedProperty + " (" + clazz.getName() + ")", invocationTargetException);
            }
            catch (SerializationException serializationException) {
                serializationException.addTrace(cachedProperty + " (" + clazz.getName() + ")");
                throw serializationException;
            }
            catch (RuntimeException runtimeException) {
                object = new SerializationException(runtimeException);
                ((SerializationException)object).addTrace(cachedProperty + " (" + clazz.getName() + ")");
                throw object;
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read bean: " + t);
        }
        return t;
    }

    class CachedProperty {
        String name;
        Method getMethod;
        Method setMethod;
        Class setMethodType;
        Serializer serializer;
        int getterAccessIndex;
        int setterAccessIndex;

        CachedProperty() {
        }

        public String toString() {
            return this.name;
        }

        Object get(Object object) throws IllegalAccessException, InvocationTargetException {
            if (BeanSerializer.this.access != null) {
                return ((MethodAccess)BeanSerializer.this.access).invoke(object, this.getterAccessIndex, new Object[0]);
            }
            return this.getMethod.invoke(object, noArgs);
        }

        void set(Object object, Object object2) throws IllegalAccessException, InvocationTargetException {
            if (BeanSerializer.this.access != null) {
                ((MethodAccess)BeanSerializer.this.access).invoke(object, this.setterAccessIndex, object2);
                return;
            }
            this.setMethod.invoke(object, object2);
        }
    }
}

