/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class IntSerializer
extends Serializer {
    private boolean optimizePositive = true;

    public IntSerializer() {
    }

    public IntSerializer(boolean bl) {
        this.optimizePositive = bl;
    }

    public Integer readObjectData(ByteBuffer byteBuffer, Class clazz) {
        int n = IntSerializer.get(byteBuffer, this.optimizePositive);
        if (Log.TRACE) {
            Log.trace("kryo", "Read int: " + n);
        }
        return n;
    }

    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        IntSerializer.put(byteBuffer, (Integer)object, this.optimizePositive);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote int: " + object);
        }
    }

    public static int put(ByteBuffer byteBuffer, int n, boolean bl) {
        if (!bl) {
            n = n << 1 ^ n >> 31;
        }
        if ((n & 0xFFFFFF80) == 0) {
            byteBuffer.put((byte)n);
            return 1;
        }
        byteBuffer.put((byte)(n & 0x7F | 0x80));
        if (((n >>>= 7) & 0xFFFFFF80) == 0) {
            byteBuffer.put((byte)n);
            return 2;
        }
        byteBuffer.put((byte)(n & 0x7F | 0x80));
        if (((n >>>= 7) & 0xFFFFFF80) == 0) {
            byteBuffer.put((byte)n);
            return 3;
        }
        byteBuffer.put((byte)(n & 0x7F | 0x80));
        if (((n >>>= 7) & 0xFFFFFF80) == 0) {
            byteBuffer.put((byte)n);
            return 4;
        }
        byteBuffer.put((byte)(n & 0x7F | 0x80));
        byteBuffer.put((byte)(n >>>= 7));
        return 5;
    }

    public static int get(ByteBuffer byteBuffer, boolean bl) {
        int n = 0;
        for (int i = 0; i < 32; i += 7) {
            byte by = byteBuffer.get();
            n |= (by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            if (!bl) {
                n = n >>> 1 ^ -(n & 1);
            }
            return n;
        }
        throw new SerializationException("Malformed integer.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canRead(ByteBuffer byteBuffer, boolean bl) {
        int n = byteBuffer.position();
        try {
            int n2;
            int n3 = byteBuffer.remaining();
            for (n2 = 0; n2 < 32 && n3 > 0; n2 += 7, --n3) {
                if ((byteBuffer.get() & 0x80) != 0) continue;
                boolean bl2 = true;
                return bl2;
            }
            n2 = 0;
            return n2 != 0;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    public static int length(int n, boolean bl) {
        if (!bl) {
            n = n << 1 ^ n >> 31;
        }
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if (((n >>>= 7) & 0xFFFFFF80) == 0) {
            return 2;
        }
        if (((n >>>= 7) & 0xFFFFFF80) == 0) {
            return 3;
        }
        if (((n >>>= 7) & 0xFFFFFF80) == 0) {
            return 4;
        }
        n >>>= 7;
        return 5;
    }
}

