/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.Configuration$Visibility;
import org.apache.ivy.core.module.descriptor.ConfigurationAware;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultIncludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.conflict.FixedConflictManager;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.AbstractModuleDescriptorParser$AbstractParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.AbstractPatternsBasedResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.URLResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class XmlModuleDescriptorParser$Parser
extends AbstractModuleDescriptorParser$AbstractParser {
    private static List ALLOWED_VERSIONS = Arrays.asList("1.0", "1.1", "1.2", "1.3", "1.4", "2.0", "2.1", "2.2");
    private ParserSettings settings;
    private boolean validate = true;
    private URL descriptorURL;
    private int state = 0;
    private PatternMatcher defaultMatcher;
    private DefaultDependencyDescriptor dd;
    private ConfigurationAware confAware;
    private MDArtifact artifact;
    private String conf;
    private boolean artifactsDeclared = false;
    private StringBuffer buffer;
    private String descriptorVersion;
    private String[] publicationsDefaultConf;

    public XmlModuleDescriptorParser$Parser(ModuleDescriptorParser moduleDescriptorParser, ParserSettings parserSettings) {
        super(moduleDescriptorParser);
        this.settings = parserSettings;
        IvySettings ivySettings = IvyContext.getContext().getSettings();
        DependencyResolver dependencyResolver = null;
        Iterator iterator2 = ivySettings.getResolvers().iterator();
        while (iterator2.hasNext()) {
            DependencyResolver dependencyResolver2 = (DependencyResolver)iterator2.next();
            if (!dependencyResolver2.getName().equals("module-inheritance-repository")) continue;
            dependencyResolver = dependencyResolver2;
            break;
        }
        if (dependencyResolver == null) {
            dependencyResolver = new URLResolver();
            dependencyResolver.setName("module-inheritance-repository");
            ivySettings.addResolver(dependencyResolver);
        }
    }

    public final void setInput(URL uRL) {
        this.descriptorURL = uRL;
    }

    public final void setValidate(boolean bl) {
        this.validate = bl;
    }

    public final void parse() {
        try {
            URL uRL;
            URL uRL2 = uRL = this.validate ? this.getClass().getResource("ivy.xsd") : null;
            if (this.descriptorURL != null) {
                XMLHelper.parse(this.descriptorURL, uRL, this);
            } else {
                XMLHelper.parse$7b13091c(null, uRL, this);
            }
            this.checkConfigurations();
            XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser = this;
            Configuration[] configurationArray = xmlModuleDescriptorParser$Parser.getMd().getConfigurations();
            for (int i = 0; i < configurationArray.length; ++i) {
                configurationArray[i].replaceWildcards(xmlModuleDescriptorParser$Parser.getMd());
            }
            this.getMd().setModuleArtifact(DefaultArtifact.newIvyArtifact(this.getMd().getResolvedModuleRevisionId(), this.getMd().getPublicationDate()));
            if (!this.artifactsDeclared) {
                String[] stringArray = this.getMd().getConfigurationsNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.getMd().addArtifact(stringArray[i], new MDArtifact(this.getMd(), this.getMd().getModuleRevisionId().getName(), "jar", "jar"));
                }
            }
            this.getMd().check();
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IllegalStateException illegalStateException = new IllegalStateException(parserConfigurationException.getMessage() + " in " + this.descriptorURL);
            illegalStateException.initCause(parserConfigurationException);
            throw illegalStateException;
        }
        catch (Exception exception) {
            this.checkErrors();
            ParseException parseException = new ParseException(exception.getMessage() + " in " + this.descriptorURL, 0);
            parseException.initCause(exception);
            throw parseException;
        }
    }

    public final void startElement(String string, String string2, String string3, Attributes attributes) {
        try {
            if (this.state == 11) {
                this.buffer.append("<").append(string3);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.buffer.append(" ");
                    this.buffer.append(attributes.getQName(i));
                    this.buffer.append("=\"");
                    this.buffer.append(attributes.getValue(i));
                    this.buffer.append("\"");
                }
                this.buffer.append(">");
                return;
            }
            if ("ivy-module".equals(string3)) {
                Attributes attributes2 = attributes;
                XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser = this;
                this.descriptorVersion = attributes2.getValue("version");
                int n = ALLOWED_VERSIONS.indexOf(xmlModuleDescriptorParser$Parser.descriptorVersion);
                if (n == -1) {
                    xmlModuleDescriptorParser$Parser.addError("invalid version " + xmlModuleDescriptorParser$Parser.descriptorVersion);
                    throw new SAXException("invalid version " + xmlModuleDescriptorParser$Parser.descriptorVersion);
                }
                if (n >= ALLOWED_VERSIONS.indexOf("1.3")) {
                    Message.debug("post 1.3 ivy file: using exact as default matcher");
                    xmlModuleDescriptorParser$Parser.defaultMatcher = xmlModuleDescriptorParser$Parser.settings.getMatcher("exact");
                } else {
                    Message.debug("pre 1.3 ivy file: using exactOrRegexp as default matcher");
                    xmlModuleDescriptorParser$Parser.defaultMatcher = xmlModuleDescriptorParser$Parser.settings.getMatcher("exactOrRegexp");
                }
                for (int i = 0; i < attributes2.getLength(); ++i) {
                    if (!attributes2.getQName(i).startsWith("xmlns:")) continue;
                    xmlModuleDescriptorParser$Parser.getMd().addExtraAttributeNamespace(attributes2.getQName(i).substring(6), attributes2.getValue(i));
                }
                return;
            }
            if ("info".equals(string3)) {
                Object object;
                Attributes attributes3 = attributes;
                XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser = this;
                this.state = 1;
                String string4 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes3.getValue("organisation"));
                String string5 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes3.getValue("module"));
                String string6 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes3.getValue("revision"));
                String string7 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes3.getValue("branch"));
                xmlModuleDescriptorParser$Parser.getMd().setModuleRevisionId(ModuleRevisionId.newInstance(string4, string5, string7, string6, LogOptions.getExtraAttributes(xmlModuleDescriptorParser$Parser.settings, attributes3, new String[]{"organisation", "module", "revision", "status", "publication", "branch", "namespace", "default", "resolver"})));
                String string8 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes3.getValue("namespace"));
                if (string8 != null) {
                    object = xmlModuleDescriptorParser$Parser.settings.getNamespace(string8);
                    if (object == null) {
                        Message.warn("namespace not found for " + xmlModuleDescriptorParser$Parser.getMd().getModuleRevisionId() + ": " + string8);
                    } else {
                        xmlModuleDescriptorParser$Parser.getMd().setNamespace((Namespace)object);
                    }
                }
                object = xmlModuleDescriptorParser$Parser.settings.substitute(attributes3.getValue("status"));
                xmlModuleDescriptorParser$Parser.getMd().setStatus((String)(object == null ? xmlModuleDescriptorParser$Parser.settings.getStatusManager().getDefaultStatus() : object));
                xmlModuleDescriptorParser$Parser.getMd().setDefault(Boolean.valueOf(xmlModuleDescriptorParser$Parser.settings.substitute(attributes3.getValue("default"))));
                String string9 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes3.getValue("publication"));
                if (string9 != null && string9.length() > 0) {
                    try {
                        xmlModuleDescriptorParser$Parser.getMd().setPublicationDate(Ivy.DATE_FORMAT.parse(string9));
                        return;
                    }
                    catch (ParseException parseException) {
                        xmlModuleDescriptorParser$Parser.addError("invalid publication date format: " + string9);
                    }
                }
                xmlModuleDescriptorParser$Parser.getMd().setPublicationDate(xmlModuleDescriptorParser$Parser.getDefaultPubDate());
                return;
            }
            if (this.state == 1 && "extends".equals(string3)) {
                Object object;
                Object object2;
                XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser;
                List<String> list;
                Attributes attributes4 = attributes;
                XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser2 = this;
                String string10 = xmlModuleDescriptorParser$Parser2.settings.substitute(attributes4.getValue("organisation"));
                String string11 = xmlModuleDescriptorParser$Parser2.settings.substitute(attributes4.getValue("module"));
                String string12 = attributes4.getValue("revision") != null ? xmlModuleDescriptorParser$Parser2.settings.substitute(attributes4.getValue("revision")) : Ivy.getWorkingRevision();
                String string13 = attributes4.getValue("location") != null ? xmlModuleDescriptorParser$Parser2.settings.substitute(attributes4.getValue("location")) : "../ivy.xml";
                List<String> list2 = Arrays.asList((attributes4.getValue("extendType") != null ? xmlModuleDescriptorParser$Parser2.settings.substitute(attributes4.getValue("extendType").toLowerCase(Locale.US)) : "all").split(","));
                ModuleId moduleId = new ModuleId(string10, string11);
                ModuleRevisionId moduleRevisionId = new ModuleRevisionId(moduleId, string12);
                try {
                    list = string13;
                    xmlModuleDescriptorParser$Parser = xmlModuleDescriptorParser$Parser2;
                    object2 = xmlModuleDescriptorParser$Parser.settings.getRelativeUrlResolver().getURL(xmlModuleDescriptorParser$Parser.descriptorURL, (String)((Object)list));
                    if (((URL)object2).openConnection().getContentLength() > 0) {
                        object = (URLResolver)IvyContext.getContext().getSettings().getResolver("module-inheritance-repository");
                        if (object == null) {
                            throw new ParseException("Unable to find module inheritance repository", 0);
                        }
                        if (!((AbstractPatternsBasedResolver)object).getIvyPatterns().contains(((URL)object2).toExternalForm())) {
                            Message.debug("Registering parent module into module inheritance repository, parent module location is " + ((URL)object2).toExternalForm());
                            ((AbstractPatternsBasedResolver)object).addIvyPattern(((URL)object2).toExternalForm());
                        }
                    }
                }
                catch (IOException iOException) {
                    Message.warn("Unable to parse included ivy file " + string13 + ": " + iOException.getMessage());
                }
                list = moduleRevisionId;
                xmlModuleDescriptorParser$Parser = xmlModuleDescriptorParser$Parser2;
                Message.debug("Trying to load included ivy file from module inheritance repository ");
                object2 = new DefaultDependencyDescriptor((ModuleRevisionId)((Object)list), true);
                Object object3 = IvyContext.getContext().getIvy().getResolveEngine();
                object = new ResolveOptions();
                ((ResolveOptions)object).setDownload$5370cc5a();
                Object object4 = new ResolveData((ResolveEngine)object3, (ResolveOptions)object);
                DependencyResolver dependencyResolver = IvyContext.getContext().getSettings().getResolver("module-inheritance-repository");
                Namespace namespace = xmlModuleDescriptorParser$Parser.settings.getContextNamespace();
                object2 = DefaultDependencyDescriptor.transformInstance((DependencyDescriptor)object2, namespace);
                ResolvedModuleRevision resolvedModuleRevision = dependencyResolver.getDependency((DependencyDescriptor)object2, (ResolveData)object4);
                ModuleDescriptor moduleDescriptor = resolvedModuleRevision != null ? resolvedModuleRevision.getDescriptor() : null;
                if (moduleDescriptor == null) {
                    try {
                        list = moduleRevisionId;
                        xmlModuleDescriptorParser$Parser = xmlModuleDescriptorParser$Parser2;
                        Message.debug("Trying to parse included ivy file by asking repository for module :" + ((ModuleRevisionId)((Object)list)).toString());
                        object2 = new DefaultDependencyDescriptor((ModuleRevisionId)((Object)list), true);
                        object3 = IvyContext.getContext().getResolveData();
                        if (object3 == null) {
                            object = IvyContext.getContext().getIvy().getResolveEngine();
                            object4 = new ResolveOptions();
                            ((ResolveOptions)object4).setDownload$5370cc5a();
                            object3 = new ResolveData((ResolveEngine)object, (ResolveOptions)object4);
                        }
                        if ((object4 = (object = xmlModuleDescriptorParser$Parser.settings.getResolver((ModuleRevisionId)((Object)list))).getDependency((DependencyDescriptor)(object2 = DefaultDependencyDescriptor.transformInstance((DependencyDescriptor)object2, namespace = xmlModuleDescriptorParser$Parser.settings.getContextNamespace())), (ResolveData)object3)) == null) {
                            throw new ParseException("Unable to find " + ((ModuleRevisionId)((Object)list)).toString(), 0);
                        }
                        moduleDescriptor = ((ResolvedModuleRevision)object4).getDescriptor();
                    }
                    catch (ParseException parseException) {
                        Message.warn("Unable to parse included ivy file for " + moduleRevisionId.toString());
                    }
                }
                if (moduleDescriptor == null) {
                    throw new ParseException("Unable to parse included ivy file for " + moduleRevisionId.toString(), 0);
                }
                ExtendsDescriptor extendsDescriptor = new ExtendsDescriptor(moduleDescriptor.getModuleRevisionId(), moduleDescriptor.getResolvedModuleRevisionId(), attributes4.getValue("location"), list2.toArray(new String[list2.size()]));
                xmlModuleDescriptorParser$Parser2.getMd().addInheritedDescriptor(extendsDescriptor);
                object2 = moduleDescriptor;
                list = list2;
                xmlModuleDescriptorParser$Parser = xmlModuleDescriptorParser$Parser2;
                if (list.contains("all")) {
                    object = object2;
                    object3 = xmlModuleDescriptorParser$Parser;
                    ((XmlModuleDescriptorParser$Parser)object3).mergeInfo((ModuleDescriptor)object);
                    super.mergeConfigurations((ModuleDescriptor)object);
                    super.mergeDependencies(object.getDependencies());
                    super.mergeDescription(object.getDescription());
                    super.mergeLicenses(object.getLicenses());
                    return;
                }
                if (list.contains("info")) {
                    xmlModuleDescriptorParser$Parser.mergeInfo((ModuleDescriptor)object2);
                }
                if (list.contains("configurations")) {
                    xmlModuleDescriptorParser$Parser.mergeConfigurations((ModuleDescriptor)object2);
                }
                if (list.contains("dependencies")) {
                    xmlModuleDescriptorParser$Parser.mergeDependencies(object2.getDependencies());
                }
                if (list.contains("description")) {
                    xmlModuleDescriptorParser$Parser.mergeDescription(object2.getDescription());
                }
                if (list.contains("licenses")) {
                    xmlModuleDescriptorParser$Parser.mergeLicenses(object2.getLicenses());
                }
                return;
            }
            if (this.state == 1 && "license".equals(string3)) {
                this.getMd().addLicense(new License(this.settings.substitute(attributes.getValue("name")), this.settings.substitute(attributes.getValue("url"))));
                return;
            }
            if (this.state == 1 && "description".equals(string3)) {
                this.getMd().setHomePage(this.settings.substitute(attributes.getValue("homepage")));
                this.state = 11;
                this.buffer = new StringBuffer();
                return;
            }
            if (!(this.state == 1 && "ivyauthor".equals(string3) || this.state == 1 && "repository".equals(string3))) {
                if (this.state == 1 && string3.indexOf(58) != -1) {
                    this.buffer = new StringBuffer();
                    this.state = 12;
                    return;
                }
                if ("configurations".equals(string3)) {
                    Attributes attributes5 = attributes;
                    XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser = this;
                    this.state = 2;
                    xmlModuleDescriptorParser$Parser.setDefaultConfMapping(xmlModuleDescriptorParser$Parser.settings.substitute(attributes5.getValue("defaultconfmapping")));
                    xmlModuleDescriptorParser$Parser.setDefaultConf(xmlModuleDescriptorParser$Parser.settings.substitute(attributes5.getValue("defaultconf")));
                    xmlModuleDescriptorParser$Parser.getMd().setMappingOverride(Boolean.valueOf(xmlModuleDescriptorParser$Parser.settings.substitute(attributes5.getValue("confmappingoverride"))));
                    return;
                }
                if ("publications".equals(string3)) {
                    Attributes attributes6 = attributes;
                    XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser = this;
                    this.state = 3;
                    xmlModuleDescriptorParser$Parser.artifactsDeclared = true;
                    xmlModuleDescriptorParser$Parser.checkConfigurations();
                    String string14 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes6.getValue("defaultconf"));
                    if (string14 != null) {
                        String string15 = string14;
                        xmlModuleDescriptorParser$Parser.publicationsDefaultConf = string15 == null ? null : string15.split(",");
                    }
                    return;
                }
                if ("dependencies".equals(string3)) {
                    String string16;
                    Attributes attributes7 = attributes;
                    XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser = this;
                    this.state = 10;
                    String string17 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes7.getValue("defaultconf"));
                    if (string17 != null) {
                        xmlModuleDescriptorParser$Parser.setDefaultConf(string17);
                    }
                    if ((string17 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes7.getValue("defaultconfmapping"))) != null) {
                        xmlModuleDescriptorParser$Parser.setDefaultConfMapping(string17);
                    }
                    if ((string16 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes7.getValue("confmappingoverride"))) != null) {
                        xmlModuleDescriptorParser$Parser.getMd().setMappingOverride(Boolean.valueOf(string16));
                    }
                    xmlModuleDescriptorParser$Parser.checkConfigurations();
                    return;
                }
                if ("conflicts".equals(string3)) {
                    if (!this.descriptorVersion.startsWith("1.")) {
                        Message.deprecated("using conflicts section is deprecated: please use hints section instead. Ivy file URL: " + this.descriptorURL);
                    }
                    this.state = 8;
                    this.checkConfigurations();
                    return;
                }
                if ("artifact".equals(string3)) {
                    this.artifactStarted(string3, attributes);
                    return;
                }
                if ("include".equals(string3) && this.state == 4) {
                    Attributes attributes8 = attributes;
                    String string18 = string3;
                    XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser = this;
                    this.state = 6;
                    xmlModuleDescriptorParser$Parser.parseRule(string18, attributes8);
                    return;
                }
                if ("exclude".equals(string3) && this.state == 4) {
                    Attributes attributes9 = attributes;
                    String string19 = string3;
                    XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser = this;
                    this.state = 7;
                    xmlModuleDescriptorParser$Parser.parseRule(string19, attributes9);
                    return;
                }
                if ("exclude".equals(string3) && this.state == 10) {
                    this.state = 9;
                    this.parseRule(string3, attributes);
                    this.getMd().addExcludeRule((ExcludeRule)((Object)this.confAware));
                    return;
                }
                if ("dependency".equals(string3)) {
                    Attributes attributes10 = attributes;
                    XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser = this;
                    this.state = 4;
                    String string20 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes10.getValue("org"));
                    if (string20 == null) {
                        string20 = xmlModuleDescriptorParser$Parser.getMd().getModuleRevisionId().getOrganisation();
                    }
                    boolean bl = Boolean.valueOf(xmlModuleDescriptorParser$Parser.settings.substitute(attributes10.getValue("force")));
                    boolean bl2 = Boolean.valueOf(xmlModuleDescriptorParser$Parser.settings.substitute(attributes10.getValue("changing")));
                    boolean bl3 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes10.getValue("transitive")) == null ? true : Boolean.valueOf(attributes10.getValue("transitive"));
                    String string21 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes10.getValue("name"));
                    String string22 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes10.getValue("branch"));
                    String string23 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes10.getValue("branchConstraint"));
                    String string24 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes10.getValue("rev"));
                    String string25 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes10.getValue("revConstraint"));
                    Map map2 = LogOptions.getExtraAttributes(xmlModuleDescriptorParser$Parser.settings, attributes10, XmlModuleDescriptorParser.DEPENDENCY_REGULAR_ATTRIBUTES);
                    ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(string20, string21, string22, string24, map2);
                    ModuleRevisionId moduleRevisionId2 = string25 == null && string23 == null ? ModuleRevisionId.newInstance$24f5ceb1(string20, string21, string22, string24, map2) : (string23 == null ? ModuleRevisionId.newInstance$24f5ceb1(string20, string21, null, string25, map2) : ModuleRevisionId.newInstance(string20, string21, string23, string25, map2));
                    xmlModuleDescriptorParser$Parser.dd = new DefaultDependencyDescriptor(xmlModuleDescriptorParser$Parser.getMd(), moduleRevisionId, moduleRevisionId2, bl, bl2, bl3);
                    xmlModuleDescriptorParser$Parser.getMd().addDependency(xmlModuleDescriptorParser$Parser.dd);
                    String string26 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes10.getValue("conf"));
                    if (string26 != null && string26.length() > 0) {
                        xmlModuleDescriptorParser$Parser.parseDepsConfs(string26, xmlModuleDescriptorParser$Parser.dd);
                    }
                    return;
                }
                if ("conf".equals(string3)) {
                    this.confStarted(attributes);
                    return;
                }
                if ("mapped".equals(string3)) {
                    this.dd.addDependencyConfiguration(this.conf, this.settings.substitute(attributes.getValue("name")));
                    return;
                }
                if ("conflict".equals(string3) && this.state == 10 || "manager".equals(string3) && this.state == 8) {
                    this.managerStarted(attributes, this.state == 8 ? "name" : "manager");
                    return;
                }
                if ("override".equals(string3) && this.state == 10) {
                    Attributes attributes11 = attributes;
                    XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser = this;
                    String string27 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes11.getValue("org"));
                    string27 = string27 == null ? "*" : string27;
                    String string28 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes11.getValue("module"));
                    string28 = string28 == null ? "*" : string28;
                    String string29 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes11.getValue("rev"));
                    String string30 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes11.getValue("branch"));
                    String string31 = xmlModuleDescriptorParser$Parser.settings.substitute(attributes11.getValue("matcher"));
                    PatternMatcher patternMatcher = string31 == null ? xmlModuleDescriptorParser$Parser.defaultMatcher : xmlModuleDescriptorParser$Parser.settings.getMatcher(string31);
                    if (patternMatcher == null) {
                        xmlModuleDescriptorParser$Parser.addError("unknown matcher: " + string31);
                        return;
                    }
                    xmlModuleDescriptorParser$Parser.getMd().addDependencyDescriptorMediator(new ModuleId(string27, string28), patternMatcher, new OverrideDependencyDescriptorMediator(string30, string29));
                    return;
                }
                if ("include".equals(string3) && this.state == 2) {
                    this.includeConfStarted(attributes);
                    return;
                }
                if (this.validate && this.state != 12 && this.state != 11) {
                    this.addError("unknown tag " + string3);
                }
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception instanceof SAXException) {
                throw (SAXException)exception2;
            }
            SAXException sAXException = new SAXException("Problem occurred while parsing ivy file: " + exception2.getMessage(), exception2);
            sAXException.initCause(exception2);
            throw sAXException;
        }
    }

    private void mergeInfo(ModuleDescriptor moduleDescriptor) {
        ModuleRevisionId moduleRevisionId = moduleDescriptor.getModuleRevisionId();
        DefaultModuleDescriptor defaultModuleDescriptor = this.getMd();
        ModuleRevisionId moduleRevisionId2 = defaultModuleDescriptor.getModuleRevisionId();
        String string = moduleRevisionId2.getOrganisation();
        String string2 = moduleRevisionId.getOrganisation();
        String string3 = string == null ? string2 : string;
        String string4 = moduleRevisionId2.getName();
        string = moduleRevisionId2.getBranch();
        string2 = moduleRevisionId.getBranch();
        String string5 = string == null ? string2 : string;
        Object object = moduleRevisionId2.getRevision();
        Object object2 = moduleRevisionId.getRevision();
        Object object3 = object == null || ((String)object).equals(Ivy.getWorkingRevision()) ? object2 : object;
        object = moduleRevisionId2.getQualifiedExtraAttributes();
        object2 = moduleRevisionId.getQualifiedExtraAttributes();
        LinkedHashMap linkedHashMap = new LinkedHashMap(object2.size() + object.size());
        linkedHashMap.putAll(object2);
        linkedHashMap.putAll(object);
        ModuleRevisionId moduleRevisionId3 = ModuleRevisionId.newInstance(string3, string4, string5, (String)object3, linkedHashMap);
        defaultModuleDescriptor.setModuleRevisionId(moduleRevisionId3);
        defaultModuleDescriptor.setResolvedModuleRevisionId(moduleRevisionId3);
        string = defaultModuleDescriptor.getStatus();
        string2 = moduleDescriptor.getStatus();
        defaultModuleDescriptor.setStatus(string == null ? string2 : string);
        if (defaultModuleDescriptor.getNamespace() == null && moduleDescriptor instanceof DefaultModuleDescriptor) {
            Namespace namespace = ((DefaultModuleDescriptor)moduleDescriptor).getNamespace();
            defaultModuleDescriptor.setNamespace(namespace);
        }
    }

    private void mergeConfigurations(ModuleDescriptor moduleDescriptor) {
        ModuleRevisionId moduleRevisionId = moduleDescriptor.getModuleRevisionId();
        Configuration[] configurationArray = moduleDescriptor.getConfigurations();
        for (int i = 0; i < configurationArray.length; ++i) {
            Configuration configuration = configurationArray[i];
            Message.debug("Merging configuration with: " + configuration.getName());
            this.getMd().addConfiguration(new Configuration(configuration, moduleRevisionId));
        }
        if (moduleDescriptor instanceof DefaultModuleDescriptor) {
            this.setDefaultConfMapping(((DefaultModuleDescriptor)moduleDescriptor).getDefaultConfMapping());
            this.setDefaultConf(((DefaultModuleDescriptor)moduleDescriptor).getDefaultConf());
            this.getMd().setMappingOverride(((DefaultModuleDescriptor)moduleDescriptor).isMappingOverride());
        }
    }

    private void mergeDependencies(DependencyDescriptor[] dependencyDescriptorArray) {
        DefaultModuleDescriptor defaultModuleDescriptor = this.getMd();
        for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
            DependencyDescriptor dependencyDescriptor = dependencyDescriptorArray[i];
            Message.debug("Merging dependency with: " + dependencyDescriptor.getDependencyRevisionId().toString());
            defaultModuleDescriptor.addDependency(dependencyDescriptor);
        }
    }

    private void mergeDescription(String string) {
        String string2 = this.getMd().getDescription();
        if (string2 == null || string2.trim().length() == 0) {
            this.getMd().setDescription(string);
        }
    }

    private void mergeLicenses(License[] licenseArray) {
        for (int i = 0; i < licenseArray.length; ++i) {
            this.getMd().addLicense(licenseArray[i]);
        }
    }

    private void managerStarted(Attributes attributes, String string) {
        ConflictManager conflictManager;
        Object object;
        String string2 = this.settings.substitute(attributes.getValue("org"));
        string2 = string2 == null ? "*" : string2;
        String string3 = this.settings.substitute(attributes.getValue("module"));
        string3 = string3 == null ? "*" : string3;
        String string4 = this.settings.substitute(attributes.getValue(string));
        String string5 = this.settings.substitute(attributes.getValue("rev"));
        if (string5 != null) {
            object = string5.split(",");
            for (int i = 0; i < ((String[])object).length; ++i) {
                object[i] = object[i].trim();
            }
            conflictManager = new FixedConflictManager((String[])object);
        } else if (string4 != null) {
            conflictManager = this.settings.getConflictManager(string4);
            if (conflictManager == null) {
                this.addError("unknown conflict manager: " + string4);
                return;
            }
        } else {
            this.addError("bad conflict manager: no manager nor rev");
            return;
        }
        object = this.settings.substitute(attributes.getValue("matcher"));
        PatternMatcher patternMatcher = object == null ? this.defaultMatcher : this.settings.getMatcher((String)object);
        if (patternMatcher == null) {
            this.addError("unknown matcher: " + (String)object);
            return;
        }
        this.getMd().addConflictManager(new ModuleId(string2, string3), patternMatcher, conflictManager);
    }

    private void includeConfStarted(Attributes attributes) {
        URL uRL;
        URL uRL2 = this.settings.getRelativeUrlResolver().getURL(this.descriptorURL, this.settings.substitute(attributes.getValue("file")), this.settings.substitute(attributes.getValue("url")));
        if (uRL2 == null) {
            throw new SAXException("include tag must have a file or an url attribute");
        }
        XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser = new XmlModuleDescriptorParser$Parser(this.getModuleDescriptorParser(), this.settings);
        new XmlModuleDescriptorParser$Parser(this.getModuleDescriptorParser(), this.settings).descriptorURL = uRL = uRL2;
        xmlModuleDescriptorParser$Parser.setMd(new DefaultModuleDescriptor(this.getModuleDescriptorParser(), new URLResource(uRL2)));
        XMLHelper.parse(uRL2, null, xmlModuleDescriptorParser$Parser);
        Configuration[] configurationArray = xmlModuleDescriptorParser$Parser.getModuleDescriptor().getConfigurations();
        for (int i = 0; i < configurationArray.length; ++i) {
            this.getMd().addConfiguration(configurationArray[i]);
        }
        if (xmlModuleDescriptorParser$Parser.getDefaultConfMapping() != null) {
            Message.debug("setting default conf mapping from imported configurations file: " + xmlModuleDescriptorParser$Parser.getDefaultConfMapping());
            this.setDefaultConfMapping(xmlModuleDescriptorParser$Parser.getDefaultConfMapping());
        }
        if (xmlModuleDescriptorParser$Parser.getDefaultConf() != null) {
            Message.debug("setting default conf from imported configurations file: " + xmlModuleDescriptorParser$Parser.getDefaultConf());
            this.setDefaultConf(xmlModuleDescriptorParser$Parser.getDefaultConf());
        }
        if (xmlModuleDescriptorParser$Parser.getMd().isMappingOverride()) {
            Message.debug("enabling mapping-override from imported configurations file");
            this.getMd().setMappingOverride(true);
        }
    }

    private void confStarted(Attributes attributes) {
        String string = this.settings.substitute(attributes.getValue("name"));
        switch (this.state) {
            case 2: {
                String string2 = this.settings.substitute(attributes.getValue("visibility"));
                String string3 = this.settings.substitute(attributes.getValue("extends"));
                boolean bl = attributes.getValue("transitive") == null ? true : Boolean.valueOf(attributes.getValue("transitive"));
                String string4 = attributes.getValue("deprecated");
                Configuration configuration = new Configuration(string, Configuration$Visibility.getVisibility(string2 == null ? "public" : string2), this.settings.substitute(attributes.getValue("description")), string3 == null ? null : string3.split(","), bl, string4);
                String[] stringArray = new String[]{"name", "visibility", "extends", "transitive", "description", "deprecated"};
                Attributes attributes2 = attributes;
                Configuration configuration2 = configuration;
                Map map2 = LogOptions.getExtraAttributes(this.settings, attributes2, stringArray);
                Iterator iterator2 = map2.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string5 = (String)iterator2.next();
                    String string6 = (String)map2.get(string5);
                    configuration2.setExtraAttribute(string5, string6);
                }
                this.getMd().addConfiguration(configuration);
                return;
            }
            case 3: {
                if ("*".equals(string)) {
                    String[] stringArray = this.getMd().getConfigurationsNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.artifact.addConfiguration(stringArray[i]);
                        this.getMd().addArtifact(stringArray[i], this.artifact);
                    }
                    return;
                }
                this.artifact.addConfiguration(string);
                this.getMd().addArtifact(string, this.artifact);
                return;
            }
            case 4: {
                this.conf = string;
                String string7 = this.settings.substitute(attributes.getValue("mapped"));
                if (string7 == null) break;
                String[] stringArray = string7.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.dd.addDependencyConfiguration(string, stringArray[i].trim());
                }
                return;
            }
            case 5: 
            case 6: 
            case 7: {
                this.addConfiguration(string);
                return;
            }
            default: {
                if (!this.validate) break;
                this.addError("conf tag found in invalid tag: " + this.state);
            }
        }
    }

    private void artifactStarted(String string, Attributes attributes) {
        if (this.state == 3) {
            String string2 = this.settings.substitute(attributes.getValue("name"));
            string2 = string2 == null ? this.getMd().getModuleRevisionId().getName() : string2;
            String string3 = this.settings.substitute(attributes.getValue("type"));
            string3 = string3 == null ? "jar" : string3;
            String string4 = this.settings.substitute(attributes.getValue("ext"));
            string4 = string4 != null ? string4 : string3;
            String string5 = this.settings.substitute(attributes.getValue("url"));
            this.artifact = new MDArtifact(this.getMd(), string2, string3, string4, string5 == null ? null : new URL(string5), LogOptions.getExtraAttributes(this.settings, attributes, new String[]{"ext", "type", "name", "conf"}));
            String string6 = this.settings.substitute(attributes.getValue("conf"));
            if (string6 != null && string6.length() > 0) {
                String[] stringArray = "*".equals(string6) ? this.getMd().getConfigurationsNames() : string6.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.artifact.addConfiguration(stringArray[i].trim());
                    this.getMd().addArtifact(stringArray[i].trim(), this.artifact);
                }
            }
            return;
        }
        if (this.state == 4) {
            Attributes attributes2 = attributes;
            String string7 = string;
            XmlModuleDescriptorParser$Parser xmlModuleDescriptorParser$Parser = this;
            this.state = 5;
            xmlModuleDescriptorParser$Parser.parseRule(string7, attributes2);
            return;
        }
        if (this.validate) {
            this.addError("artifact tag found in invalid tag: " + this.state);
        }
    }

    private void parseRule(String string, Attributes attributes) {
        Map map2;
        ArtifactId artifactId;
        String string2;
        Object object;
        Object object2;
        String string3;
        String string4;
        String string5 = this.settings.substitute(attributes.getValue("name"));
        if (string5 == null && (string5 = this.settings.substitute(attributes.getValue("artifact"))) == null) {
            String string6 = string5 = "artifact".equals(string) ? this.dd.getDependencyId().getName() : "*";
        }
        if ((string4 = this.settings.substitute(attributes.getValue("type"))) == null) {
            string4 = "artifact".equals(string) ? "jar" : "*";
        }
        String string7 = string3 = (string3 = this.settings.substitute(attributes.getValue("ext"))) != null ? string3 : string4;
        if (this.state == 5) {
            object2 = this.settings.substitute(attributes.getValue("url"));
            object = LogOptions.getExtraAttributes(this.settings, attributes, new String[]{"name", "type", "ext", "url", "conf"});
            this.confAware = new DefaultDependencyArtifactDescriptor(this.dd, string5, string4, string3, object2 == null ? null : new URL((String)object2), (Map)object);
        } else if (this.state == 6) {
            object2 = this.getPatternMatcher(attributes.getValue("matcher"));
            object = this.settings.substitute(attributes.getValue("org"));
            object = object == null ? "*" : object;
            string2 = this.settings.substitute(attributes.getValue("module"));
            string2 = string2 == null ? "*" : string2;
            artifactId = new ArtifactId(new ModuleId((String)object, string2), string5, string4, string3);
            map2 = LogOptions.getExtraAttributes(this.settings, attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
            this.confAware = new DefaultIncludeRule(artifactId, (PatternMatcher)object2, map2);
        } else {
            object2 = this.getPatternMatcher(attributes.getValue("matcher"));
            object = this.settings.substitute(attributes.getValue("org"));
            object = object == null ? "*" : object;
            string2 = this.settings.substitute(attributes.getValue("module"));
            string2 = string2 == null ? "*" : string2;
            artifactId = new ArtifactId(new ModuleId((String)object, string2), string5, string4, string3);
            map2 = LogOptions.getExtraAttributes(this.settings, attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
            this.confAware = new DefaultExcludeRule(artifactId, (PatternMatcher)object2, map2);
        }
        object2 = this.settings.substitute(attributes.getValue("conf"));
        if (object2 != null && ((String)object2).length() > 0) {
            object = "*".equals(object2) ? this.getMd().getConfigurationsNames() : ((String)object2).split(",");
            for (int i = 0; i < ((String[])object).length; ++i) {
                this.addConfiguration(object[i].trim());
            }
        }
    }

    private void addConfiguration(String string) {
        this.confAware.addConfiguration(string);
        if (this.state != 9) {
            if (this.confAware instanceof DependencyArtifactDescriptor) {
                this.dd.addDependencyArtifact(string, (DependencyArtifactDescriptor)((Object)this.confAware));
                return;
            }
            if (this.confAware instanceof IncludeRule) {
                this.dd.addIncludeRule(string, (IncludeRule)((Object)this.confAware));
                return;
            }
            if (this.confAware instanceof ExcludeRule) {
                this.dd.addExcludeRule(string, (ExcludeRule)((Object)this.confAware));
            }
        }
    }

    private PatternMatcher getPatternMatcher(String string) {
        String string2 = this.settings.substitute(string);
        PatternMatcher patternMatcher = string2 == null ? this.defaultMatcher : this.settings.getMatcher(string2);
        if (patternMatcher == null) {
            throw new IllegalArgumentException("unknown matcher " + string2);
        }
        return patternMatcher;
    }

    public final void characters(char[] cArray, int n, int n2) {
        if (this.buffer != null) {
            this.buffer.append(cArray, n, n2);
        }
    }

    public final void endElement(String string, String string2, String string3) {
        if (this.state == 3 && "artifact".equals(string3) && this.artifact.getConfigurations().length == 0) {
            String[] stringArray = this.publicationsDefaultConf == null ? this.getMd().getConfigurationsNames() : this.publicationsDefaultConf;
            for (int i = 0; i < stringArray.length; ++i) {
                this.artifact.addConfiguration(stringArray[i].trim());
                this.getMd().addArtifact(stringArray[i].trim(), this.artifact);
            }
            return;
        }
        if ("configurations".equals(string3)) {
            this.checkConfigurations();
            return;
        }
        if (this.state == 5 && "artifact".equals(string3) || this.state == 6 && "include".equals(string3) || this.state == 7 && "exclude".equals(string3)) {
            this.state = 4;
            if (this.confAware.getConfigurations().length == 0) {
                String[] stringArray = this.getMd().getConfigurationsNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addConfiguration(stringArray[i]);
                }
            }
            this.confAware = null;
            return;
        }
        if ("exclude".equals(string3) && this.state == 9) {
            if (this.confAware.getConfigurations().length == 0) {
                String[] stringArray = this.getMd().getConfigurationsNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addConfiguration(stringArray[i]);
                }
            }
            this.confAware = null;
            this.state = 10;
            return;
        }
        if ("dependency".equals(string3) && this.state == 4) {
            if (this.dd.getModuleConfigurations().length == 0) {
                this.parseDepsConfs(this.getDefaultConf(), this.dd);
            }
            this.state = 10;
            return;
        }
        if ("dependencies".equals(string3) && this.state == 10) {
            this.state = 0;
            return;
        }
        if (this.state == 1 && "info".equals(string3)) {
            this.state = 0;
            return;
        }
        if (this.state == 11 && "description".equals(string3)) {
            this.getMd().setDescription(this.buffer == null ? "" : this.buffer.toString().trim());
            this.buffer = null;
            this.state = 1;
            return;
        }
        if (this.state == 12) {
            this.getMd().addExtraInfo(string3, this.buffer == null ? "" : this.buffer.toString());
            this.buffer = null;
            this.state = 1;
            return;
        }
        if (this.state == 11) {
            if (this.buffer.toString().endsWith("<" + string3 + ">")) {
                this.buffer.deleteCharAt(this.buffer.length() - 1);
                this.buffer.append("/>");
                return;
            }
            this.buffer.append("</" + string3 + ">");
        }
    }

    private void checkConfigurations() {
        if (this.getMd().getConfigurations().length == 0) {
            this.getMd().addConfiguration(new Configuration("default"));
        }
    }
}

