/*
 * Decompiled with CFR 0.152.
 */
package org.libsdl.app;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.SparseArray;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.libsdl.app.AtomicActivity;
import org.libsdl.app.DummyEdit;
import org.libsdl.app.SDLJoystickHandler;
import org.libsdl.app.SDLJoystickHandler_API12;
import org.libsdl.app.SDLSurface;

public class SDLActivity {
    private static final String TAG = "SDL";
    public static boolean mIsPaused;
    public static boolean mIsSurfaceReady;
    public static boolean mHasFocus;
    public static boolean mExitCalledFromJava;
    public static boolean mSeparateMouseAndTouch;
    protected static Activity mSingleton;
    protected static SDLSurface mSurface;
    protected static View mTextEdit;
    protected static ViewGroup mLayout;
    protected static SDLJoystickHandler mJoystickHandler;
    protected static Thread mSDLThread;
    protected static AudioTrack mAudioTrack;
    protected static AudioRecord mAudioRecord;
    private static boolean mIsSharedLibraryLoaded;
    public static boolean FinishActivityOnNativeExit;
    static final int COMMAND_CHANGE_TITLE = 1;
    static final int COMMAND_UNUSED = 2;
    static final int COMMAND_TEXTEDIT_HIDE = 3;
    static final int COMMAND_SET_KEEP_SCREEN_ON = 5;
    protected static final int COMMAND_USER = 32768;
    static Handler commandHandler;
    private Object expansionFile;
    private Method expansionFileMethod;
    protected static final int[] messageboxSelection;
    protected int dialogs = 0;

    public static SDLSurface createSurface(Activity activity) {
        SDLActivity.initialize();
        mSingleton = activity;
        if (!mIsSharedLibraryLoaded) {
            System.loadLibrary("AtomicNETNative");
            mIsSharedLibraryLoaded = true;
        }
        mSurface = new SDLSurface((Context)activity.getApplication());
        mJoystickHandler = Build.VERSION.SDK_INT >= 12 ? new SDLJoystickHandler_API12() : new SDLJoystickHandler();
        return mSurface;
    }

    protected boolean onLoadLibrary(ArrayList<String> libraryNames) {
        for (String name : libraryNames) {
            System.loadLibrary(name);
        }
        return true;
    }

    protected static String[] getArguments() {
        return new String[]{"app_process"};
    }

    public static void initialize() {
        mSingleton = null;
        mSurface = null;
        mTextEdit = null;
        mLayout = null;
        mJoystickHandler = null;
        mSDLThread = null;
        mAudioTrack = null;
        mAudioRecord = null;
        mExitCalledFromJava = false;
        mIsPaused = false;
        mIsSurfaceReady = false;
        mHasFocus = true;
    }

    public static void onPause() {
        Log.v((String)TAG, (String)"onPause()");
        if (!mIsSharedLibraryLoaded) {
            return;
        }
        SDLActivity.handlePause();
    }

    public static void onResume() {
        Log.v((String)TAG, (String)"onResume()");
        if (!mIsSharedLibraryLoaded) {
            return;
        }
        SDLActivity.handleResume();
    }

    public static void onWindowFocusChanged(boolean hasFocus) {
        Log.v((String)TAG, (String)("onWindowFocusChanged(): " + hasFocus));
        if (!mIsSharedLibraryLoaded) {
            return;
        }
        mHasFocus = hasFocus;
        if (hasFocus) {
            SDLActivity.handleResume();
        }
    }

    public static void onLowMemory() {
        Log.v((String)TAG, (String)"onLowMemory()");
        if (!mIsSharedLibraryLoaded) {
            return;
        }
        SDLActivity.nativeLowMemory();
    }

    public static void onDestroy() {
        Log.v((String)TAG, (String)"onDestroy()");
        if (!mIsSharedLibraryLoaded) {
            SDLActivity.initialize();
            return;
        }
        mExitCalledFromJava = true;
        SDLActivity.nativeQuit();
        if (mSDLThread != null) {
            try {
                mSDLThread.join();
            }
            catch (Exception e) {
                Log.v((String)TAG, (String)("Problem stopping thread: " + e));
            }
            mSDLThread = null;
        }
        SDLActivity.initialize();
    }

    public static boolean dispatchKeyEvent(KeyEvent event) {
        if (!mIsSharedLibraryLoaded) {
            return false;
        }
        int keyCode = event.getKeyCode();
        return keyCode != 25 && keyCode != 24 && keyCode != 3 && keyCode != 27 && keyCode != 168 && keyCode != 169;
    }

    public static void handlePause() {
        if (!mIsPaused && mIsSurfaceReady) {
            mIsPaused = true;
            SDLActivity.nativePause();
            mSurface.handlePause();
        }
    }

    public static void handleResume() {
        if (mIsPaused && mIsSurfaceReady && mHasFocus) {
            mIsPaused = false;
            SDLActivity.nativeResume();
            mSurface.handleResume();
        }
    }

    public static void handleNativeExit() {
        mSDLThread = null;
        if (mSingleton != null && FinishActivityOnNativeExit) {
            mSingleton.finish();
        }
    }

    protected boolean onUnhandledMessage(int command, Object param) {
        return false;
    }

    public static boolean sendCommand(int command, Object data) {
        Message msg = commandHandler.obtainMessage();
        msg.arg1 = command;
        msg.obj = data;
        return commandHandler.sendMessage(msg);
    }

    public static native int nativeInit(Object var0, String var1);

    public static native void nativeLowMemory();

    public static native void nativeQuit();

    public static native void nativePause();

    public static native void nativeResume();

    public static native void onNativeDropFile(String var0);

    public static native void onNativeResize(int var0, int var1, int var2, float var3);

    public static native int onNativePadDown(int var0, int var1);

    public static native int onNativePadUp(int var0, int var1);

    public static native void onNativeJoy(int var0, int var1, float var2);

    public static native void onNativeHat(int var0, int var1, int var2, int var3);

    public static native void onNativeKeyDown(int var0);

    public static native void onNativeKeyUp(int var0);

    public static native void onNativeKeyboardFocusLost();

    public static native void onNativeMouse(int var0, int var1, float var2, float var3);

    public static native void onNativeTouch(int var0, int var1, int var2, float var3, float var4, float var5);

    public static native void onNativeAccel(float var0, float var1, float var2);

    public static native void onNativeSurfaceChanged();

    public static native void onNativeSurfaceDestroyed();

    public static native int nativeAddJoystick(int var0, String var1, int var2, int var3, int var4, int var5, int var6);

    public static native int nativeRemoveJoystick(int var0);

    public static native String nativeGetHint(String var0);

    public static boolean setActivityTitle(String title) {
        return SDLActivity.sendCommand(1, title);
    }

    public static boolean sendMessage(int command, int param) {
        return SDLActivity.sendCommand(command, param);
    }

    public static Context getContext() {
        return mSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSystemServiceFromUiThread(final String name) {
        final Object lock = new Object();
        final Object[] results = new Object[2];
        Object object = lock;
        synchronized (object) {
            mSingleton.runOnUiThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = lock;
                    synchronized (object) {
                        results[0] = mSingleton.getSystemService(name);
                        results[1] = Boolean.TRUE;
                        lock.notify();
                    }
                }
            });
            if (results[1] == null) {
                try {
                    lock.wait();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return results[0];
    }

    public static boolean showTextInput(int x, int y, int w, int h) {
        return commandHandler.post((Runnable)new ShowTextInputTask(x, y, w, h));
    }

    public static Surface getNativeSurface() {
        return mSurface.getNativeSurface();
    }

    public static int audioOpen(int sampleRate, boolean is16Bit, boolean isStereo, int desiredFrames) {
        int channelConfig = isStereo ? 3 : 2;
        int audioFormat = is16Bit ? 2 : 3;
        int frameSize = (isStereo ? 2 : 1) * (is16Bit ? 2 : 1);
        Log.v((String)TAG, (String)("SDL audio: wanted " + (isStereo ? "stereo" : "mono") + " " + (is16Bit ? "16-bit" : "8-bit") + " " + (float)sampleRate / 1000.0f + "kHz, " + desiredFrames + " frames buffer"));
        desiredFrames = Math.max(desiredFrames, (AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)audioFormat) + frameSize - 1) / frameSize);
        if (mAudioTrack == null) {
            mAudioTrack = new AudioTrack(3, sampleRate, channelConfig, audioFormat, desiredFrames * frameSize, 1);
            if (mAudioTrack.getState() != 1) {
                Log.e((String)TAG, (String)"Failed during initialization of Audio Track");
                mAudioTrack = null;
                return -1;
            }
            mAudioTrack.play();
        }
        Log.v((String)TAG, (String)("SDL audio: got " + (mAudioTrack.getChannelCount() >= 2 ? "stereo" : "mono") + " " + (mAudioTrack.getAudioFormat() == 2 ? "16-bit" : "8-bit") + " " + (float)mAudioTrack.getSampleRate() / 1000.0f + "kHz, " + desiredFrames + " frames buffer"));
        return 0;
    }

    public static void audioWriteShortBuffer(short[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            int result = mAudioTrack.write(buffer, i, buffer.length - i);
            if (result > 0) {
                i += result;
                continue;
            }
            if (result == 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Log.w((String)TAG, (String)"SDL audio: error return from write(short)");
            return;
        }
    }

    public static void audioWriteByteBuffer(byte[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            int result = mAudioTrack.write(buffer, i, buffer.length - i);
            if (result > 0) {
                i += result;
                continue;
            }
            if (result == 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Log.w((String)TAG, (String)"SDL audio: error return from write(byte)");
            return;
        }
    }

    public static int captureOpen(int sampleRate, boolean is16Bit, boolean isStereo, int desiredFrames) {
        int channelConfig = isStereo ? 3 : 2;
        int audioFormat = is16Bit ? 2 : 3;
        int frameSize = (isStereo ? 2 : 1) * (is16Bit ? 2 : 1);
        Log.v((String)TAG, (String)("SDL capture: wanted " + (isStereo ? "stereo" : "mono") + " " + (is16Bit ? "16-bit" : "8-bit") + " " + (float)sampleRate / 1000.0f + "kHz, " + desiredFrames + " frames buffer"));
        desiredFrames = Math.max(desiredFrames, (AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)audioFormat) + frameSize - 1) / frameSize);
        if (mAudioRecord == null) {
            mAudioRecord = new AudioRecord(0, sampleRate, channelConfig, audioFormat, desiredFrames * frameSize);
            if (mAudioRecord.getState() != 1) {
                Log.e((String)TAG, (String)"Failed during initialization of AudioRecord");
                mAudioRecord.release();
                mAudioRecord = null;
                return -1;
            }
            mAudioRecord.startRecording();
        }
        Log.v((String)TAG, (String)("SDL capture: got " + (mAudioRecord.getChannelCount() >= 2 ? "stereo" : "mono") + " " + (mAudioRecord.getAudioFormat() == 2 ? "16-bit" : "8-bit") + " " + (float)mAudioRecord.getSampleRate() / 1000.0f + "kHz, " + desiredFrames + " frames buffer"));
        return 0;
    }

    public static int captureReadShortBuffer(short[] buffer, boolean blocking) {
        return mAudioRecord.read(buffer, 0, buffer.length);
    }

    public static int captureReadByteBuffer(byte[] buffer, boolean blocking) {
        return mAudioRecord.read(buffer, 0, buffer.length);
    }

    public static void audioClose() {
        if (mAudioTrack != null) {
            mAudioTrack.stop();
            mAudioTrack.release();
            mAudioTrack = null;
        }
    }

    public static void captureClose() {
        if (mAudioRecord != null) {
            mAudioRecord.stop();
            mAudioRecord.release();
            mAudioRecord = null;
        }
    }

    public static int[] inputGetInputDeviceIds(int sources) {
        int[] ids = InputDevice.getDeviceIds();
        int[] filtered = new int[ids.length];
        int used = 0;
        for (int i = 0; i < ids.length; ++i) {
            InputDevice device = InputDevice.getDevice((int)ids[i]);
            if (device == null || (device.getSources() & sources) == 0) continue;
            filtered[used++] = device.getId();
        }
        return Arrays.copyOf(filtered, used);
    }

    public static boolean handleJoystickMotionEvent(MotionEvent event) {
        return mJoystickHandler != null && mJoystickHandler.handleMotionEvent(event);
    }

    public static void pollInputDevices() {
        if (mSDLThread != null && mJoystickHandler != null) {
            mJoystickHandler.pollInputDevices();
        }
    }

    public static boolean isDeviceSDLJoystick(int deviceId) {
        InputDevice device = InputDevice.getDevice((int)deviceId);
        if (device == null || deviceId < 0) {
            return false;
        }
        int sources = device.getSources();
        return (sources & 0x10) == 16 || (sources & 0x201) == 513 || (sources & 0x401) == 1025;
    }

    public InputStream openAPKExpansionInputStream(String fileName) throws IOException {
        InputStream fileStream;
        if (this.expansionFile == null) {
            Integer patchVersion;
            Integer mainVersion;
            String mainHint = SDLActivity.nativeGetHint("SDL_ANDROID_APK_EXPANSION_MAIN_FILE_VERSION");
            if (mainHint == null) {
                return null;
            }
            String patchHint = SDLActivity.nativeGetHint("SDL_ANDROID_APK_EXPANSION_PATCH_FILE_VERSION");
            if (patchHint == null) {
                return null;
            }
            try {
                mainVersion = Integer.valueOf(mainHint);
                patchVersion = Integer.valueOf(patchHint);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                throw new IOException("No valid file versions set for APK expansion files", ex);
            }
            try {
                this.expansionFile = Class.forName("com.android.vending.expansion.zipfile.APKExpansionSupport").getMethod("getAPKExpansionZipFile", Context.class, Integer.TYPE, Integer.TYPE).invoke(null, this, mainVersion, patchVersion);
                this.expansionFileMethod = this.expansionFile.getClass().getMethod("getInputStream", String.class);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.expansionFile = null;
                this.expansionFileMethod = null;
                throw new IOException("Could not access APK expansion support library", ex);
            }
        }
        try {
            fileStream = (InputStream)this.expansionFileMethod.invoke(this.expansionFile, fileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Could not open stream from APK expansion file", ex);
        }
        if (fileStream == null) {
            throw new IOException("Could not find path in APK expansion file");
        }
        return fileStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int messageboxShowMessageBox(int flags, String title, String message, int[] buttonFlags, int[] buttonIds, String[] buttonTexts, int[] colors) {
        SDLActivity.messageboxSelection[0] = -1;
        if (buttonFlags.length != buttonIds.length && buttonIds.length != buttonTexts.length) {
            return -1;
        }
        final Bundle args = new Bundle();
        args.putInt("flags", flags);
        args.putString("title", title);
        args.putString("message", message);
        args.putIntArray("buttonFlags", buttonFlags);
        args.putIntArray("buttonIds", buttonIds);
        args.putStringArray("buttonTexts", buttonTexts);
        args.putIntArray("colors", colors);
        mSingleton.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                mSingleton.showDialog(SDLActivity.this.dialogs++, args);
            }
        });
        int[] nArray = messageboxSelection;
        synchronized (messageboxSelection) {
            try {
                messageboxSelection.wait();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return -1;
            }
            return messageboxSelection[0];
        }
    }

    public static Dialog onCreateDialog(int ignore, Bundle args) {
        int buttonSelectedColor;
        int buttonBackgroundColor;
        int buttonBorderColor;
        int textColor;
        int backgroundColor;
        int[] colors = args.getIntArray("colors");
        if (colors != null) {
            int i = -1;
            backgroundColor = colors[++i];
            textColor = colors[++i];
            buttonBorderColor = colors[++i];
            buttonBackgroundColor = colors[++i];
            buttonSelectedColor = colors[++i];
        } else {
            backgroundColor = 0;
            textColor = 0;
            buttonBorderColor = 0;
            buttonBackgroundColor = 0;
            buttonSelectedColor = 0;
        }
        final Dialog dialog = new Dialog((Context)mSingleton);
        dialog.setTitle((CharSequence)args.getString("title"));
        dialog.setCancelable(false);
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onDismiss(DialogInterface unused) {
                int[] nArray = messageboxSelection;
                synchronized (messageboxSelection) {
                    messageboxSelection.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        TextView message = new TextView((Context)mSingleton);
        message.setGravity(17);
        message.setText((CharSequence)args.getString("message"));
        if (textColor != 0) {
            message.setTextColor(textColor);
        }
        int[] buttonFlags = args.getIntArray("buttonFlags");
        int[] buttonIds = args.getIntArray("buttonIds");
        String[] buttonTexts = args.getStringArray("buttonTexts");
        final SparseArray mapping = new SparseArray();
        LinearLayout buttons = new LinearLayout((Context)mSingleton);
        buttons.setOrientation(0);
        buttons.setGravity(17);
        for (int i = 0; i < buttonTexts.length; ++i) {
            Button button = new Button((Context)mSingleton);
            final int id = buttonIds[i];
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SDLActivity.messageboxSelection[0] = id;
                    dialog.dismiss();
                }
            });
            if (buttonFlags[i] != 0) {
                if ((buttonFlags[i] & 1) != 0) {
                    mapping.put(66, (Object)button);
                }
                if ((buttonFlags[i] & 2) != 0) {
                    mapping.put(111, (Object)button);
                }
            }
            button.setText((CharSequence)buttonTexts[i]);
            if (textColor != 0) {
                button.setTextColor(textColor);
            }
            if (buttonBorderColor != 0) {
                // empty if block
            }
            if (buttonBackgroundColor != 0) {
                Drawable drawable = button.getBackground();
                if (drawable == null) {
                    button.setBackgroundColor(buttonBackgroundColor);
                } else {
                    drawable.setColorFilter(buttonBackgroundColor, PorterDuff.Mode.MULTIPLY);
                }
            }
            if (buttonSelectedColor != 0) {
                // empty if block
            }
            buttons.addView((View)button);
        }
        LinearLayout content = new LinearLayout((Context)mSingleton);
        content.setOrientation(1);
        content.addView((View)message);
        content.addView((View)buttons);
        if (backgroundColor != 0) {
            content.setBackgroundColor(backgroundColor);
        }
        dialog.setContentView((View)content);
        dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface d, int keyCode, KeyEvent event) {
                Button button = (Button)mapping.get(keyCode);
                if (button != null) {
                    if (event.getAction() == 1) {
                        button.performClick();
                    }
                    return true;
                }
                return false;
            }
        });
        return dialog;
    }

    static {
        mIsSharedLibraryLoaded = false;
        FinishActivityOnNativeExit = true;
        commandHandler = new SDLCommandHandler();
        messageboxSelection = new int[1];
    }

    static class ShowTextInputTask
    implements Runnable {
        static final int HEIGHT_PADDING = 15;
        public int x;
        public int y;
        public int w;
        public int h;

        public ShowTextInputTask(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        @Override
        public void run() {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(this.w, this.h + 15);
            params.leftMargin = this.x;
            params.topMargin = this.y;
            if (mTextEdit == null) {
                mTextEdit = new DummyEdit(SDLActivity.getContext());
                mLayout.addView(mTextEdit, (ViewGroup.LayoutParams)params);
            } else {
                mTextEdit.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            mTextEdit.setVisibility(0);
            mTextEdit.requestFocus();
            InputMethodManager imm = (InputMethodManager)SDLActivity.getContext().getSystemService("input_method");
            imm.showSoftInput(mTextEdit, 0);
        }
    }

    protected static class SDLCommandHandler
    extends Handler {
        protected SDLCommandHandler() {
        }

        public void handleMessage(Message msg) {
            Context context = SDLActivity.getContext();
            if (context == null) {
                Log.e((String)SDLActivity.TAG, (String)"error handling message, getContext() returned null");
                return;
            }
            switch (msg.arg1) {
                case 1: {
                    if (context instanceof Activity) {
                        ((Activity)context).setTitle((CharSequence)((String)msg.obj));
                        break;
                    }
                    Log.e((String)SDLActivity.TAG, (String)"error handling message, getContext() returned no Activity");
                    break;
                }
                case 3: {
                    if (mTextEdit == null) break;
                    mTextEdit.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(0, 0));
                    InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
                    imm.hideSoftInputFromWindow(mTextEdit.getWindowToken(), 0);
                    break;
                }
                case 5: {
                    Window window = ((Activity)context).getWindow();
                    if (window == null) break;
                    if (msg.obj instanceof Integer && (Integer)msg.obj != 0) {
                        window.addFlags(128);
                        break;
                    }
                    window.clearFlags(128);
                    break;
                }
                default: {
                    if (!(context instanceof AtomicActivity) || ((AtomicActivity)context).onUnhandledMessage(msg.arg1, msg.obj)) break;
                    Log.e((String)SDLActivity.TAG, (String)("error handling message, command is " + msg.arg1));
                }
            }
        }
    }
}

