/*
 * Decompiled with CFR 0.152.
 */
package org.libsdl.app;

import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import org.libsdl.app.SDLActivity;

class SDLInputConnection
extends BaseInputConnection {
    public SDLInputConnection(View targetView, boolean fullEditor) {
        super(targetView, fullEditor);
    }

    public boolean sendKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (event.getAction() == 0) {
            if (event.isPrintingKey() || keyCode == 62) {
                this.commitText(String.valueOf((char)event.getUnicodeChar()), 1);
            }
            SDLActivity.onNativeKeyDown(keyCode);
            return true;
        }
        if (event.getAction() == 1) {
            SDLActivity.onNativeKeyUp(keyCode);
            return true;
        }
        return super.sendKeyEvent(event);
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        this.nativeCommitText(text.toString(), newCursorPosition);
        return super.commitText(text, newCursorPosition);
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        this.nativeSetComposingText(text.toString(), newCursorPosition);
        return super.setComposingText(text, newCursorPosition);
    }

    public native void nativeCommitText(String var1, int var2);

    public native void nativeSetComposingText(String var1, int var2);

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        if (beforeLength == 1 && afterLength == 0) {
            return super.sendKeyEvent(new KeyEvent(0, 67)) && super.sendKeyEvent(new KeyEvent(1, 67));
        }
        return super.deleteSurroundingText(beforeLength, afterLength);
    }
}

