/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.internal.client.zzad;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzr;
import com.google.android.gms.ads.internal.client.zzs;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzem;
import com.google.android.gms.internal.zzen;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzgp;

public class AdLoader {
    private final zzh zzajr;
    private final Context mContext;
    private final zzr zzajs;

    AdLoader(Context context, zzr zzr2) {
        this(context, zzr2, zzh.zzjb());
    }

    AdLoader(Context context, zzr zzr2, zzh zzh2) {
        this.mContext = context;
        this.zzajs = zzr2;
        this.zzajr = zzh2;
    }

    private void zza(zzad zzad2) {
        try {
            this.zzajs.zzf(this.zzajr.zza(this.mContext, zzad2));
        }
        catch (RemoteException remoteException) {
            zzb.zzb("Failed to load ad.", remoteException);
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzdg());
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzdg());
    }

    public String getMediationAdapterClassName() {
        try {
            return this.zzajs.getMediationAdapterClassName();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzajs.isLoading();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context mContext;
        private final zzs zzajt;

        public Builder(Context context, String string) {
            this((Context)zzac.zzb((Object)context, (Object)"context cannot be null"), zzm.zzjs().zzb(context, string, new zzgp()));
        }

        Builder(Context context, zzs zzs2) {
            this.mContext = context;
            this.zzajt = zzs2;
        }

        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzajt.zza(new zzen(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzajt.zza(new zzem(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzajt.zza(string, new zzep(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzeo(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzajt.zzb(new zzc(adListener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzajt.zza(new NativeAdOptionsParcel(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(@NonNull Correlator correlator) {
            zzac.zzy((Object)correlator);
            try {
                this.zzajt.zzb(correlator.zzdh());
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.mContext, this.zzajt.zzey());
            }
            catch (RemoteException remoteException) {
                zzb.zzb("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

