/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.search;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Bundle;
import com.google.android.gms.ads.internal.client.zzad;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;

public final class SearchAdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final String DEVICE_ID_EMULATOR = zzad.DEVICE_ID_EMULATOR;
    public static final int BORDER_TYPE_NONE = 0;
    public static final int BORDER_TYPE_DASHED = 1;
    public static final int BORDER_TYPE_DOTTED = 2;
    public static final int BORDER_TYPE_SOLID = 3;
    public static final int CALL_BUTTON_COLOR_LIGHT = 0;
    public static final int CALL_BUTTON_COLOR_MEDIUM = 1;
    public static final int CALL_BUTTON_COLOR_DARK = 2;
    private final zzad zzaju;
    private final int zzcxs;
    private final int mBackgroundColor;
    private final int zzcxt;
    private final int zzcxu;
    private final int zzcxv;
    private final int zzcxw;
    private final int zzcxx;
    private final int zzcxy;
    private final String zzcxz;
    private final int zzcya;
    private final String zzcyb;
    private final int zzcyc;
    private final int zzcyd;
    private final String zzapl;

    private SearchAdRequest(Builder builder) {
        this.zzcxs = builder.zzcxs;
        this.mBackgroundColor = builder.mBackgroundColor;
        this.zzcxt = builder.zzcxt;
        this.zzcxu = builder.zzcxu;
        this.zzcxv = builder.zzcxv;
        this.zzcxw = builder.zzcxw;
        this.zzcxx = builder.zzcxx;
        this.zzcxy = builder.zzcxy;
        this.zzcxz = builder.zzcxz;
        this.zzcya = builder.zzcya;
        this.zzcyb = builder.zzcyb;
        this.zzcyc = builder.zzcyc;
        this.zzcyd = builder.zzcyd;
        this.zzapl = builder.zzapl;
        this.zzaju = new zzad(builder.zzajv, this);
    }

    public int getAnchorTextColor() {
        return this.zzcxs;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getBackgroundGradientBottom() {
        return this.zzcxt;
    }

    public int getBackgroundGradientTop() {
        return this.zzcxu;
    }

    public int getBorderColor() {
        return this.zzcxv;
    }

    public int getBorderThickness() {
        return this.zzcxw;
    }

    public int getBorderType() {
        return this.zzcxx;
    }

    public int getCallButtonColor() {
        return this.zzcxy;
    }

    public String getCustomChannels() {
        return this.zzcxz;
    }

    public int getDescriptionTextColor() {
        return this.zzcya;
    }

    public String getFontFace() {
        return this.zzcyb;
    }

    public int getHeaderTextColor() {
        return this.zzcyc;
    }

    public int getHeaderTextSize() {
        return this.zzcyd;
    }

    public Location getLocation() {
        return this.zzaju.getLocation();
    }

    @Deprecated
    public <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzaju.getNetworkExtras(clazz);
    }

    public <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzaju.getNetworkExtrasBundle(clazz);
    }

    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzaju.getCustomEventExtrasBundle(clazz);
    }

    public String getQuery() {
        return this.zzapl;
    }

    public boolean isTestDevice(Context context) {
        return this.zzaju.isTestDevice(context);
    }

    zzad zzdg() {
        return this.zzaju;
    }

    public static final class Builder {
        private final zzad.zza zzajv = new zzad.zza();
        private int zzcxs;
        private int mBackgroundColor;
        private int zzcxt;
        private int zzcxu;
        private int zzcxv;
        private int zzcxw;
        private int zzcxx = 0;
        private int zzcxy;
        private String zzcxz;
        private int zzcya;
        private String zzcyb;
        private int zzcyc;
        private int zzcyd;
        private String zzapl;

        public Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzajv.zza(networkExtras);
            return this;
        }

        public Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zzajv.zza(clazz, bundle);
            return this;
        }

        public Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzajv.zzb(clazz, bundle);
            return this;
        }

        public Builder addTestDevice(String string) {
            this.zzajv.zzaj(string);
            return this;
        }

        public SearchAdRequest build() {
            return new SearchAdRequest(this);
        }

        public Builder setAnchorTextColor(int n) {
            this.zzcxs = n;
            return this;
        }

        public Builder setBackgroundColor(int n) {
            this.mBackgroundColor = n;
            this.zzcxt = Color.argb((int)0, (int)0, (int)0, (int)0);
            this.zzcxu = Color.argb((int)0, (int)0, (int)0, (int)0);
            return this;
        }

        public Builder setBackgroundGradient(int n, int n2) {
            this.mBackgroundColor = Color.argb((int)0, (int)0, (int)0, (int)0);
            this.zzcxt = n2;
            this.zzcxu = n;
            return this;
        }

        public Builder setBorderColor(int n) {
            this.zzcxv = n;
            return this;
        }

        public Builder setBorderThickness(int n) {
            this.zzcxw = n;
            return this;
        }

        public Builder setBorderType(int n) {
            this.zzcxx = n;
            return this;
        }

        public Builder setCallButtonColor(int n) {
            this.zzcxy = n;
            return this;
        }

        public Builder setCustomChannels(String string) {
            this.zzcxz = string;
            return this;
        }

        public Builder setDescriptionTextColor(int n) {
            this.zzcya = n;
            return this;
        }

        public Builder setFontFace(String string) {
            this.zzcyb = string;
            return this;
        }

        public Builder setHeaderTextColor(int n) {
            this.zzcyc = n;
            return this;
        }

        public Builder setHeaderTextSize(int n) {
            this.zzcyd = n;
            return this;
        }

        public Builder setLocation(Location location) {
            this.zzajv.zzb(location);
            return this;
        }

        public Builder setQuery(String string) {
            this.zzapl = string;
            return this;
        }

        public Builder setRequestAgent(String string) {
            this.zzajv.zzan(string);
            return this;
        }

        public Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzajv.zzo(bl);
            return this;
        }
    }
}

