/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Build;
import android.util.Log;
import com.google.android.gms.common.internal.zzq;

public class zzse {
    private final String mTag;
    private final String CR;
    private final zzq Dk;
    private final int bX;

    private static String zzd(String ... stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (String string2 : stringArray) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string2);
        }
        stringBuilder.append(']').append(' ');
        return stringBuilder.toString();
    }

    public zzse(String string2, String ... stringArray) {
        this(string2, zzse.zzd(stringArray));
    }

    private zzse(String string2, String string3) {
        this.CR = string3;
        this.mTag = string2;
        this.Dk = new zzq(string2);
        this.bX = this.getLogLevel();
    }

    private int getLogLevel() {
        int n;
        if (Build.VERSION.SDK_INT == 23) {
            String string2 = String.valueOf(this.mTag);
            String string3 = System.getProperty(string2.length() != 0 ? "log.tag.".concat(string2) : new String("log.tag."));
            if (string3 != null) {
                switch (string3) {
                    case "VERBOSE": {
                        return 2;
                    }
                    case "DEBUG": {
                        return 3;
                    }
                    case "INFO": {
                        return 4;
                    }
                    case "WARN": {
                        return 5;
                    }
                    case "ERROR": {
                        return 6;
                    }
                    case "ASSERT": {
                        return 7;
                    }
                    case "SUPPRESS": {
                        return Integer.MAX_VALUE;
                    }
                }
                return 4;
            }
        }
        for (n = 2; 7 >= n && !Log.isLoggable((String)this.mTag, (int)n); ++n) {
        }
        return n;
    }

    public boolean zzbf(int n) {
        return this.bX <= n;
    }

    public void zza(String string2, Object ... objectArray) {
        if (this.zzbf(2)) {
            Log.v((String)this.mTag, (String)this.format(string2, objectArray));
        }
    }

    public void zze(String string2, Object ... objectArray) {
        Log.i((String)this.mTag, (String)this.format(string2, objectArray));
    }

    public void zzf(String string2, Object ... objectArray) {
        Log.w((String)this.mTag, (String)this.format(string2, objectArray));
    }

    protected String format(String string2, Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            string2 = String.format(string2, objectArray);
        }
        return this.CR.concat(string2);
    }
}

