/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.content.IntentSender;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.internal.OpenFileIntentSenderRequest;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.internal.FilterHolder;
import com.google.android.gms.drive.query.internal.zzg;

public class OpenFileActivityBuilder {
    public static final String EXTRA_RESPONSE_DRIVE_ID = "response_drive_id";
    private String HP;
    private String[] HQ;
    private Filter HR;
    private DriveId HS;

    public OpenFileActivityBuilder setActivityTitle(String string) {
        this.HP = (String)zzac.zzy((Object)string);
        return this;
    }

    public OpenFileActivityBuilder setMimeType(String[] stringArray) {
        zzac.zzb((stringArray != null ? 1 : 0) != 0, (Object)"mimeTypes may not be null");
        this.HQ = stringArray;
        return this;
    }

    public OpenFileActivityBuilder setSelectionFilter(Filter filter) {
        zzac.zzb((filter != null ? 1 : 0) != 0, (Object)"filter may not be null");
        zzac.zzb((!zzg.zza(filter) ? 1 : 0) != 0, (Object)"FullTextSearchFilter cannot be used as a selection filter");
        this.HR = filter;
        return this;
    }

    public OpenFileActivityBuilder setActivityStartFolder(DriveId driveId) {
        this.HS = (DriveId)((Object)zzac.zzy((Object)((Object)driveId)));
        return this;
    }

    public IntentSender build(GoogleApiClient googleApiClient) {
        zzac.zza((boolean)googleApiClient.isConnected(), (Object)"Client must be connected");
        if (this.HQ == null) {
            this.HQ = new String[0];
        }
        if (this.HQ.length > 0 && this.HR != null) {
            throw new IllegalStateException("Cannot use a selection filter and set mimetypes simultaneously");
        }
        FilterHolder filterHolder = this.HR == null ? null : new FilterHolder(this.HR);
        try {
            zzam zzam2 = ((zzu)googleApiClient.zza(Drive.fa)).zzbcd();
            return zzam2.zza(new OpenFileIntentSenderRequest(this.HP, this.HQ, this.HS, filterHolder));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Unable to connect Drive Play Service", remoteException);
        }
    }
}

