/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zze;
import com.google.android.gms.drive.internal.zzap;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzsp;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
extends AbstractSafeParcelable
implements ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zze();
    final int mVersionCode;
    final DriveId Hi;
    final String fs;
    final ParcelFileDescriptor Im;
    final ParcelFileDescriptor In;
    final MetadataBundle Io;
    final List<String> Ip;
    final int zzbqm;
    final IBinder Iq;
    private boolean Ir = false;
    private boolean Is = false;
    private boolean It = false;

    CompletionEvent(int n, DriveId driveId, String string, ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, MetadataBundle metadataBundle, List<String> list, int n2, IBinder iBinder) {
        this.mVersionCode = n;
        this.Hi = driveId;
        this.fs = string;
        this.Im = parcelFileDescriptor;
        this.In = parcelFileDescriptor2;
        this.Io = metadataBundle;
        this.Ip = list;
        this.zzbqm = n2;
        this.Iq = iBinder;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n | 1);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public DriveId getDriveId() {
        this.zzbbt();
        return this.Hi;
    }

    public String getAccountName() {
        this.zzbbt();
        return this.fs;
    }

    public InputStream getBaseContentsInputStream() {
        this.zzbbt();
        if (this.Im == null) {
            return null;
        }
        if (this.Ir) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.Ir = true;
        return new FileInputStream(this.Im.getFileDescriptor());
    }

    public InputStream getModifiedContentsInputStream() {
        this.zzbbt();
        if (this.In == null) {
            return null;
        }
        if (this.Is) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.Is = true;
        return new FileInputStream(this.In.getFileDescriptor());
    }

    public MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzbbt();
        return this.Io != null ? new MetadataChangeSet(this.Io) : null;
    }

    public List<String> getTrackingTags() {
        this.zzbbt();
        return new ArrayList<String>(this.Ip);
    }

    public int getStatus() {
        this.zzbbt();
        return this.zzbqm;
    }

    public void dismiss() {
        this.zzz(false);
    }

    public void snooze() {
        this.zzz(true);
    }

    private void zzz(boolean bl) {
        this.zzbbt();
        this.It = true;
        zzo.zza((ParcelFileDescriptor)this.Im);
        zzo.zza((ParcelFileDescriptor)this.In);
        if (this.Io != null && this.Io.zzc(zzsp.Mk)) {
            this.Io.zza(zzsp.Mk).release();
        }
        if (this.Iq == null) {
            String string = String.valueOf(bl ? "snooze" : "dismiss");
            zzz.zzag("CompletionEvent", string.length() != 0 ? "No callback on ".concat(string) : new String("No callback on "));
            return;
        }
        try {
            zzap.zza.zzep(this.Iq).zzz(bl);
        }
        catch (RemoteException remoteException) {
            String string = bl ? "snooze" : "dismiss";
            String string2 = String.valueOf((Object)remoteException);
            zzz.zzag("CompletionEvent", new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append("RemoteException on ").append(string).append(": ").append(string2).toString());
        }
    }

    private void zzbbt() {
        if (this.It) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public String toString() {
        String string;
        if (this.Ip == null) {
            string = "<null>";
        } else {
            String string2 = String.valueOf(TextUtils.join((CharSequence)"','", this.Ip));
            string = new StringBuilder(2 + String.valueOf(string2).length()).append("'").append(string2).append("'").toString();
        }
        String string3 = string;
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", new Object[]{this.Hi, this.zzbqm, string3});
    }
}

