/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.annotation.SuppressLint;
import android.os.RemoteException;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.internal.CreateContentsRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.OnListEntriesResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.QueryRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzp;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzv;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.internal.zzqc;
import java.util.List;

public class zzs
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult> query(GoogleApiClient googleApiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return googleApiClient.zzc((zzqc.zza)new zzh(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzbcd().zza(new QueryRequest(query), (zzan)new zzi((zzqc.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> newDriveContents(GoogleApiClient googleApiClient) {
        return this.zzb(googleApiClient, 0x20000000);
    }

    public PendingResult<DriveApi.DriveContentsResult> zzb(GoogleApiClient googleApiClient, final int n) {
        return googleApiClient.zzc((zzqc.zza)new zzc(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzbcd().zza(new CreateContentsRequest(n), (zzan)new zza((zzqc.zzb<DriveApi.DriveContentsResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveIdResult> fetchDriveId(GoogleApiClient googleApiClient, final String string) {
        return googleApiClient.zzc((zzqc.zza)new zzf(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzbcd().zza(new GetMetadataRequest(DriveId.zzin(string), false), (zzan)new zzd((zzqc.zzb<DriveApi.DriveIdResult>)this));
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient googleApiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!googleApiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzw(driveId);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient googleApiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!googleApiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzy(driveId);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient googleApiClient) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.fa);
        if (!zzu2.zzbcg()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        DriveId driveId = zzu2.zzbce();
        return driveId != null ? new zzy(driveId) : null;
    }

    @Override
    public DriveFolder getAppFolder(GoogleApiClient googleApiClient) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.fa);
        if (!zzu2.zzbcg()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        DriveId driveId = zzu2.zzbcf();
        return driveId != null ? new zzy(driveId) : null;
    }

    @Override
    public PendingResult<Status> requestSync(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzqc.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzbcd().zza(new zzbr((zzqc.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<BooleanResult> isAutobackupEnabled(GoogleApiClient googleApiClient) {
        return googleApiClient.zzc((zzqc.zza)new zzt<BooleanResult>(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                final 5 var2_2 = this;
                zzu2.zzbcd().zze(new com.google.android.gms.drive.internal.zzd(){

                    @Override
                    public void zzbv(boolean bl) {
                        var2_2.zzc((Result)new BooleanResult(Status.vY, bl));
                    }
                });
            }

            protected BooleanResult zzak(Status status) {
                return new BooleanResult(status, false);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzak(status);
            }
        });
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status> cancelPendingActions(GoogleApiClient googleApiClient, List<String> list) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.fa);
        return zzu2.cancelPendingActions(googleApiClient, list);
    }

    private static class zzi
    extends com.google.android.gms.drive.internal.zzd {
        private final zzqc.zzb<DriveApi.MetadataBufferResult> Dj;

        public zzi(zzqc.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.Dj = zzb2;
        }

        @Override
        public void zza(OnListEntriesResponse onListEntriesResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListEntriesResponse.zzbcp());
            this.Dj.setResult((Object)new zzg(Status.vY, metadataBuffer, onListEntriesResponse.zzbcq()));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.Dj.setResult((Object)new zzg(status, null, false));
        }
    }

    static class zzg
    implements DriveApi.MetadataBufferResult {
        private final Status fp;
        private final MetadataBuffer Js;
        private final boolean Jt;

        public zzg(Status status, MetadataBuffer metadataBuffer, boolean bl) {
            this.fp = status;
            this.Js = metadataBuffer;
            this.Jt = bl;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public MetadataBuffer getMetadataBuffer() {
            return this.Js;
        }

        public void release() {
            if (this.Js != null) {
                this.Js.release();
            }
        }
    }

    static abstract class zzh
    extends zzt<DriveApi.MetadataBufferResult> {
        zzh(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.MetadataBufferResult zzan(Status status) {
            return new zzg(status, null, false);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzan(status);
        }
    }

    static class zzd
    extends com.google.android.gms.drive.internal.zzd {
        private final zzqc.zzb<DriveApi.DriveIdResult> Dj;

        public zzd(zzqc.zzb<DriveApi.DriveIdResult> zzb2) {
            this.Dj = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.Dj.setResult((Object)new zze(Status.vY, new zzp(onMetadataResponse.zzbcs()).getDriveId()));
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.Dj.setResult((Object)new zze(Status.vY, onDriveIdResponse.getDriveId()));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.Dj.setResult((Object)new zze(status, null));
        }
    }

    private static class zze
    implements DriveApi.DriveIdResult {
        private final Status fp;
        private final DriveId Hi;

        public zze(Status status, DriveId driveId) {
            this.fp = status;
            this.Hi = driveId;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public DriveId getDriveId() {
            return this.Hi;
        }
    }

    static abstract class zzf
    extends zzt<DriveApi.DriveIdResult> {
        zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveIdResult zzam(Status status) {
            return new zze(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzam(status);
        }
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zzqc.zzb<DriveApi.DriveContentsResult> Dj;

        public zza(zzqc.zzb<DriveApi.DriveContentsResult> zzb2) {
            this.Dj = zzb2;
        }

        @Override
        public void zza(OnContentsResponse onContentsResponse) throws RemoteException {
            this.Dj.setResult((Object)new zzb(Status.vY, new zzv(onContentsResponse.zzbcj())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.Dj.setResult((Object)new zzb(status, null));
        }
    }

    static class zzb
    implements Releasable,
    DriveApi.DriveContentsResult {
        private final Status fp;
        private final DriveContents Hl;

        public zzb(Status status, DriveContents driveContents) {
            this.fp = status;
            this.Hl = driveContents;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public DriveContents getDriveContents() {
            return this.Hl;
        }

        public void release() {
            if (this.Hl != null) {
                this.Hl.zzbax();
            }
        }
    }

    static abstract class zzc
    extends zzt<DriveApi.DriveContentsResult> {
        zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveContentsResult zzal(Status status) {
            return new zzb(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzal(status);
        }
    }

    @SuppressLint(value={"MissingRemoteException"})
    static class zzj
    extends zzt.zza {
        zzj(GoogleApiClient googleApiClient, Status status) {
            super(googleApiClient);
            this.zzc((Result)status);
        }

        protected void zza(zzu zzu2) {
        }
    }
}

