/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CloseContentsAndUpdateMetadataRequest;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.OpenContentsRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbi;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.zzi;
import com.google.android.gms.internal.zzqc;
import java.io.InputStream;
import java.io.OutputStream;

public class zzv
implements DriveContents {
    private final Contents JL;
    private boolean mClosed = false;
    private boolean JM = false;
    private boolean JN = false;

    public zzv(Contents contents) {
        this.JL = (Contents)((Object)zzac.zzy((Object)((Object)contents)));
    }

    @Override
    public DriveId getDriveId() {
        return this.JL.getDriveId();
    }

    @Override
    public int getMode() {
        return this.JL.getMode();
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.zzbay()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.JL.getParcelFileDescriptor();
    }

    @Override
    public InputStream getInputStream() {
        if (this.zzbay()) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.JL.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.JM) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.JM = true;
        return this.JL.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.zzbay()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.JL.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.JN) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.JN = true;
        return this.JL.getOutputStream();
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient googleApiClient) {
        if (this.zzbay()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.JL.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzbax();
        return googleApiClient.zzc((zzqc.zza)new zzs.zzc(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzbcd().zza(new OpenContentsRequest(zzv.this.getDriveId(), 0x20000000, zzv.this.JL.getRequestId()), (zzan)new zzbi((zzqc.zzb<DriveApi.DriveContentsResult>)this, null));
            }
        });
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        return this.zza(googleApiClient, metadataChangeSet, null);
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, ExecutionOptions executionOptions) {
        return this.zza(googleApiClient, metadataChangeSet, executionOptions == null ? null : zzi.zzb(executionOptions));
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, zzi zzi2) {
        if (zzi2 == null) {
            zzi2 = (zzi)new zzi.zza().build();
        }
        if (this.JL.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.zzja(zzi2.zzbbc()) && !this.JL.zzbau()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        zzi2.zzh(googleApiClient);
        if (this.zzbay()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        final MetadataChangeSet metadataChangeSet2 = metadataChangeSet != null ? metadataChangeSet : MetadataChangeSet.HM;
        final zzi zzi3 = zzi2;
        this.zzbax();
        return googleApiClient.zzd((zzqc.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                metadataChangeSet2.zzbbk().setContext(zzu2.getContext());
                zzu2.zzbcd().zza(new CloseContentsAndUpdateMetadataRequest(zzv.this.JL.getDriveId(), metadataChangeSet2.zzbbk(), zzv.this.JL.getRequestId(), zzv.this.JL.zzbau(), zzi3), (zzan)new zzbr((zzqc.zzb<Status>)this));
            }
        });
    }

    @Override
    public void discard(GoogleApiClient googleApiClient) {
        if (this.zzbay()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzbax();
        (googleApiClient.zzd((zzqc.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzbcd().zza(new CloseContentsRequest(zzv.this.JL.getRequestId(), false), (zzan)new zzbr((zzqc.zzb<Status>)this));
            }
        })).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzp(Status status) {
                if (!status.isSuccess()) {
                    zzz.zzag("DriveContentsImpl", "Error discarding contents");
                } else {
                    zzz.zzae("DriveContentsImpl", "Contents discarded");
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zzp((Status)result);
            }
        });
    }

    @Override
    public Contents zzbaw() {
        return this.JL;
    }

    @Override
    public void zzbax() {
        zzo.zza((ParcelFileDescriptor)this.JL.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public boolean zzbay() {
        return this.mClosed;
    }
}

