/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.zze;
import com.google.android.gms.drive.metadata.internal.zzh;
import com.google.android.gms.internal.zzsp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class MetadataBundle
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<MetadataBundle> CREATOR = new zzh();
    final int mVersionCode;
    final Bundle LB;

    MetadataBundle(int n, Bundle bundle) {
        this.mVersionCode = n;
        this.LB = (Bundle)zzac.zzy((Object)bundle);
        this.LB.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.LB.keySet()) {
            if (zze.zzit(string) != null) continue;
            arrayList.add(string);
            String string2 = String.valueOf(string);
            zzz.zzaf("MetadataBundle", string2.length() != 0 ? "Ignored unknown metadata field in bundle: ".concat(string2) : new String("Ignored unknown metadata field in bundle: "));
        }
        for (String string : arrayList) {
            this.LB.remove(string);
        }
    }

    private MetadataBundle(Bundle bundle) {
        this(1, bundle);
    }

    public static MetadataBundle zzbdd() {
        return new MetadataBundle(new Bundle());
    }

    public static <T> MetadataBundle zzb(MetadataField<T> metadataField, T t) {
        MetadataBundle metadataBundle = MetadataBundle.zzbdd();
        metadataBundle.zzc(metadataField, t);
        return metadataBundle;
    }

    public MetadataBundle zzbde() {
        return new MetadataBundle(new Bundle(this.LB));
    }

    public <T> void zzc(MetadataField<T> metadataField, T t) {
        if (zze.zzit(metadataField.getName()) == null) {
            String string = String.valueOf(metadataField.getName());
            throw new IllegalArgumentException(string.length() != 0 ? "Unregistered field: ".concat(string) : new String("Unregistered field: "));
        }
        metadataField.zza(t, this.LB);
    }

    public <T> T zza(MetadataField<T> metadataField) {
        return metadataField.zzr(this.LB);
    }

    public boolean zzc(MetadataField<?> metadataField) {
        return this.LB.containsKey(metadataField.getName());
    }

    public Set<MetadataField<?>> zzbdf() {
        HashSet hashSet = new HashSet();
        for (String string : this.LB.keySet()) {
            hashSet.add(zze.zzit(string));
        }
        return hashSet;
    }

    public void setContext(Context context) {
        BitmapTeleporter bitmapTeleporter = this.zza(zzsp.Mk);
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(context.getCacheDir());
        }
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        for (String string : this.LB.keySet()) {
            n2 = n2 * 31 + this.LB.get(string).hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MetadataBundle)) {
            return false;
        }
        MetadataBundle metadataBundle = (MetadataBundle)((Object)object);
        Set set = this.LB.keySet();
        if (!set.equals(metadataBundle.LB.keySet())) {
            return false;
        }
        for (String string : set) {
            if (zzab.equal((Object)this.LB.get(string), (Object)metadataBundle.LB.get(string))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = String.valueOf(this.LB);
        return new StringBuilder(24 + String.valueOf(string).length()).append("MetadataBundle [values=").append(string).append("]").toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzh.zza(this, parcel, n);
    }
}

