/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.query;

import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.SearchableCollectionMetadataField;
import com.google.android.gms.drive.metadata.SearchableMetadataField;
import com.google.android.gms.drive.metadata.SearchableOrderedMetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.drive.query.internal.ComparisonFilter;
import com.google.android.gms.drive.query.internal.FieldOnlyFilter;
import com.google.android.gms.drive.query.internal.HasFilter;
import com.google.android.gms.drive.query.internal.InFilter;
import com.google.android.gms.drive.query.internal.LogicalFilter;
import com.google.android.gms.drive.query.internal.NotFilter;
import com.google.android.gms.drive.query.internal.Operator;
import com.google.android.gms.drive.query.internal.OwnedByMeFilter;

public class Filters {
    public static <T> Filter eq(SearchableMetadataField<T> searchableMetadataField, T t) {
        return new ComparisonFilter<T>(Operator.Ni, searchableMetadataField, t);
    }

    public static <T extends Comparable<T>> Filter lessThan(SearchableOrderedMetadataField<T> searchableOrderedMetadataField, T t) {
        return new ComparisonFilter<T>(Operator.Nj, searchableOrderedMetadataField, t);
    }

    public static <T extends Comparable<T>> Filter greaterThan(SearchableOrderedMetadataField<T> searchableOrderedMetadataField, T t) {
        return new ComparisonFilter<T>(Operator.Nl, searchableOrderedMetadataField, t);
    }

    public static <T extends Comparable<T>> Filter lessThanEquals(SearchableOrderedMetadataField<T> searchableOrderedMetadataField, T t) {
        return new ComparisonFilter<T>(Operator.Nk, searchableOrderedMetadataField, t);
    }

    public static <T extends Comparable<T>> Filter greaterThanEquals(SearchableOrderedMetadataField<T> searchableOrderedMetadataField, T t) {
        return new ComparisonFilter<T>(Operator.Nm, searchableOrderedMetadataField, t);
    }

    public static <T> Filter in(SearchableCollectionMetadataField<T> searchableCollectionMetadataField, T t) {
        return new InFilter<T>(searchableCollectionMetadataField, t);
    }

    public static Filter eq(CustomPropertyKey customPropertyKey, String string) {
        zzac.zzb((string != null ? 1 : 0) != 0, (Object)"Custom property value may not be null.");
        return new HasFilter<AppVisibleCustomProperties>(SearchableField.MN, new AppVisibleCustomProperties.zza().zza(customPropertyKey, string).zzbcz());
    }

    public static Filter contains(SearchableMetadataField<String> searchableMetadataField, String string) {
        return new ComparisonFilter<String>(Operator.Nq, searchableMetadataField, string);
    }

    public static Filter and(Filter filter, Filter ... filterArray) {
        return new LogicalFilter(Operator.Nn, filter, filterArray);
    }

    public static Filter and(Iterable<Filter> iterable) {
        return new LogicalFilter(Operator.Nn, iterable);
    }

    public static Filter or(Filter filter, Filter ... filterArray) {
        return new LogicalFilter(Operator.No, filter, filterArray);
    }

    public static Filter or(Iterable<Filter> iterable) {
        return new LogicalFilter(Operator.No, iterable);
    }

    public static Filter not(Filter filter) {
        return new NotFilter(filter);
    }

    public static Filter sharedWithMe() {
        return new FieldOnlyFilter(SearchableField.MM);
    }

    public static Filter openedByMe() {
        return new FieldOnlyFilter(SearchableField.LAST_VIEWED_BY_ME);
    }

    public static Filter ownedByMe() {
        return new OwnedByMeFilter();
    }
}

