/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.query;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.drive.metadata.SortableMetadataField;
import com.google.android.gms.drive.query.internal.FieldWithSortOrder;
import com.google.android.gms.drive.query.zzb;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SortOrder
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<SortOrder> CREATOR = new zzb();
    final List<FieldWithSortOrder> MO;
    final boolean MP;
    final int mVersionCode;

    private SortOrder(List<FieldWithSortOrder> list, boolean bl) {
        this(1, list, bl);
    }

    SortOrder(int n, List<FieldWithSortOrder> list, boolean bl) {
        this.mVersionCode = n;
        this.MO = list;
        this.MP = bl;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public String toString() {
        return String.format(Locale.US, "SortOrder[%s, %s]", TextUtils.join((CharSequence)",", this.MO), this.MP);
    }

    public static class Builder {
        private final List<FieldWithSortOrder> MO = new ArrayList<FieldWithSortOrder>();
        private boolean MP = false;

        public Builder addSortAscending(SortableMetadataField sortableMetadataField) {
            this.MO.add(new FieldWithSortOrder(sortableMetadataField.getName(), true));
            return this;
        }

        public Builder addSortDescending(SortableMetadataField sortableMetadataField) {
            this.MO.add(new FieldWithSortOrder(sortableMetadataField.getName(), false));
            return this;
        }

        public SortOrder build() {
            return new SortOrder(this.MO, false);
        }
    }
}

