/*
 * Decompiled with CFR 0.152.
 */
package com.chartboost.sdk.Tracking;

import android.text.TextUtils;
import android.util.Base64;
import com.chartboost.sdk.Libraries.CBLogging;
import com.chartboost.sdk.Libraries.a;
import com.chartboost.sdk.Libraries.e;
import com.chartboost.sdk.Libraries.g;
import com.chartboost.sdk.Libraries.h;
import com.chartboost.sdk.Model.CBError;
import com.chartboost.sdk.b;
import com.chartboost.sdk.impl.az;
import com.chartboost.sdk.impl.ba;
import java.io.File;
import java.util.EnumMap;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CBAnalytics {
    private CBAnalytics() {
    }

    public synchronized void trackInAppPurchaseEvent(EnumMap<CBIAPPurchaseInfo, String> map, CBIAPType iapType) {
        if (map == null || iapType == null || TextUtils.isEmpty((CharSequence)map.get((Object)CBIAPPurchaseInfo.PRODUCT_ID)) || TextUtils.isEmpty((CharSequence)map.get((Object)CBIAPPurchaseInfo.PRODUCT_TITLE)) || TextUtils.isEmpty((CharSequence)map.get((Object)CBIAPPurchaseInfo.PRODUCT_DESCRIPTION)) || TextUtils.isEmpty((CharSequence)map.get((Object)CBIAPPurchaseInfo.PRODUCT_PRICE)) || TextUtils.isEmpty((CharSequence)map.get((Object)CBIAPPurchaseInfo.PRODUCT_CURRENCY_CODE))) {
            CBLogging.b("CBPostInstallTracker", "Null object is passed. Please pass a valid value object");
            return;
        }
        String string = map.get((Object)CBIAPPurchaseInfo.GOOGLE_PURCHASE_DATA);
        String string2 = map.get((Object)CBIAPPurchaseInfo.GOOGLE_PURCHASE_SIGNATURE);
        String string3 = map.get((Object)CBIAPPurchaseInfo.AMAZON_USER_ID);
        String string4 = map.get((Object)CBIAPPurchaseInfo.AMAZON_PURCHASE_TOKEN);
        CBAnalytics.a(map.get((Object)CBIAPPurchaseInfo.PRODUCT_ID), map.get((Object)CBIAPPurchaseInfo.PRODUCT_TITLE), map.get((Object)CBIAPPurchaseInfo.PRODUCT_DESCRIPTION), map.get((Object)CBIAPPurchaseInfo.PRODUCT_PRICE), map.get((Object)CBIAPPurchaseInfo.PRODUCT_CURRENCY_CODE), string, string2, string3, string4, iapType);
    }

    private static synchronized void a(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, CBIAPType cBIAPType) {
        Object object;
        Object object2;
        Object object3;
        if (b.w() == null) {
            CBLogging.b("CBPostInstallTracker", "You need call Chartboost.init() before calling any public API's");
            return;
        }
        if (!b.n()) {
            CBLogging.b("CBPostInstallTracker", "You need call Chartboost.OnStart() before tracking in-app purchases");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string4) || TextUtils.isEmpty((CharSequence)string5)) {
            CBLogging.b("CBPostInstallTracker", "Null object is passed. Please pass a valid value object");
            return;
        }
        float f2 = 0.0f;
        try {
            object3 = Pattern.compile("(\\d+\\.\\d+)|(\\d+)");
            object2 = ((Pattern)object3).matcher(string4);
            ((Matcher)object2).find();
            object = ((Matcher)object2).group();
            if (TextUtils.isEmpty((CharSequence)object)) {
                CBLogging.b("CBPostInstallTracker", "Invalid price object");
                return;
            }
            f2 = Float.parseFloat((String)object);
        }
        catch (IllegalStateException illegalStateException) {
            CBLogging.b("CBPostInstallTracker", "Invalid price object");
            return;
        }
        object3 = null;
        object2 = null;
        if (cBIAPType == CBIAPType.GOOGLE_PLAY) {
            if (TextUtils.isEmpty((CharSequence)string6) || TextUtils.isEmpty((CharSequence)string7)) {
                CBLogging.b("CBPostInstallTracker", "Null object is passed for for purchase data or purchase signature");
                return;
            }
            object3 = e.a(e.a("purchaseData", string6), e.a("purchaseSignature", string7), e.a("type", CBIAPType.GOOGLE_PLAY.ordinal()));
        } else if (cBIAPType == CBIAPType.AMAZON) {
            if (TextUtils.isEmpty((CharSequence)string8) || TextUtils.isEmpty((CharSequence)string9)) {
                CBLogging.b("CBPostInstallTracker", "Null object is passed for for amazon user id or amazon purchase token");
                return;
            }
            object3 = e.a(e.a("userID", string8), e.a("purchaseToken", string9), e.a("type", CBIAPType.AMAZON.ordinal()));
        }
        if (object3 == null) {
            CBLogging.b("CBPostInstallTracker", "Error while parsing the receipt to a JSON Object, ");
            return;
        }
        object2 = Base64.encodeToString((byte[])((e.a)object3).toString().getBytes(), (int)2);
        object = e.a(e.a("localized-title", string2), e.a("localized-description", string3), e.a("price", Float.valueOf(f2)), e.a("currency", string5), e.a("productID", string), e.a("receipt", object2));
        CBAnalytics.a((e.a)object, "iap", cBIAPType);
    }

    public static synchronized void trackInAppGooglePlayPurchaseEvent(String title, String description, String price, String currency, String productID, String purchaseData, String purchaseSignature) {
        CBAnalytics.a(productID, title, description, price, currency, purchaseData, purchaseSignature, null, null, CBIAPType.GOOGLE_PLAY);
    }

    public static synchronized void trackInAppAmazonStorePurchaseEvent(String title, String description, String price, String currency, String productID, String userID, String purchaseToken) {
        CBAnalytics.a(productID, title, description, price, currency, null, null, userID, purchaseToken, CBIAPType.AMAZON);
    }

    public static synchronized void trackLevelInfo(String eventLabel, CBLevelType type, int mainLevel, String description) {
        CBAnalytics.trackLevelInfo(eventLabel, type, mainLevel, 0, description);
    }

    public static synchronized void trackLevelInfo(String eventLabel, CBLevelType type, int mainLevel, int subLevel, String description) {
        if (TextUtils.isEmpty((CharSequence)eventLabel)) {
            CBLogging.b("CBPostInstallTracker", "Invalid value: event label cannot be empty or null");
            return;
        }
        if (type == null || !(type instanceof CBLevelType)) {
            CBLogging.b("CBPostInstallTracker", "Invalid value: level type cannot be empty or null, please choose from one of the CBLevelType enum values");
            return;
        }
        if (mainLevel < 0 || subLevel < 0) {
            CBLogging.b("CBPostInstallTracker", "Invalid value: Level number should be > 0");
            return;
        }
        if (description.isEmpty()) {
            CBLogging.b("CBPostInstallTracker", "Invalid value: description cannot be empty or null");
            return;
        }
        e.a a2 = e.a(e.a("event_label", eventLabel), e.a("event_field", type.getLevelType()), e.a("main_level", mainLevel), e.a("sub_level", subLevel), e.a("description", description), e.a("timestamp", System.currentTimeMillis()), e.a("data_type", "level_info"));
        CBAnalytics.a(a2, "tracking");
    }

    private static synchronized void a(e.a a2, final String string, final CBIAPType cBIAPType) {
        az az2 = new az(String.format(Locale.US, "%s%s", "/post-install-event/", string));
        az2.a(string, (Object)a2);
        az2.a(g.a(g.a("status", a.a)));
        az2.b(string);
        az2.a(true);
        az2.a(new az.c(){

            @Override
            public void a(e.a a2, az az2) {
                CBLogging.a("CBPostInstallTracker", string + " success response!!");
            }

            @Override
            public void a(e.a a2, az az2, CBError cBError) {
                if (string.equals("iap") && a2 != null && a2.f("status") == 400 && cBIAPType == CBIAPType.GOOGLE_PLAY) {
                    CBLogging.a("CBPostInstallTracker", string + " 400 response from server!!");
                    ba ba2 = ba.a(b.w());
                    h h2 = ba2.j();
                    ConcurrentHashMap<az, File> concurrentHashMap = ba2.i();
                    if (h2 != null && concurrentHashMap != null) {
                        h2.c(concurrentHashMap.get(az2));
                        concurrentHashMap.remove(az2);
                    }
                    return;
                }
                CBLogging.a("CBPostInstallTracker", string + " failure response!!");
            }
        });
    }

    private static synchronized void a(e.a a2, String string) {
        az az2 = new az("/post-install-event/".concat("tracking"));
        az2.a("track_info", (Object)a2);
        az2.a(g.a(g.a("status", a.a)));
        az2.b(string);
        az2.a(true);
        az2.s();
    }

    public static enum CBIAPPurchaseInfo {
        PRODUCT_ID,
        PRODUCT_TITLE,
        PRODUCT_DESCRIPTION,
        PRODUCT_PRICE,
        PRODUCT_CURRENCY_CODE,
        GOOGLE_PURCHASE_DATA,
        GOOGLE_PURCHASE_SIGNATURE,
        AMAZON_PURCHASE_TOKEN,
        AMAZON_USER_ID;

    }

    public static enum CBLevelType {
        HIGHEST_LEVEL_REACHED(1),
        CURRENT_AREA(2),
        CHARACTER_LEVEL(3),
        OTHER_SEQUENTIAL(4),
        OTHER_NONSEQUENTIAL(5);

        private int a;

        private CBLevelType(int value) {
            this.a = value;
        }

        public int getLevelType() {
            return this.a;
        }
    }

    public static enum CBIAPType {
        GOOGLE_PLAY,
        AMAZON;

    }
}

