/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzmh;
import java.util.Date;
import java.util.Set;

@zziy
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
MediationRewardedVideoAdAdapter,
zzmh {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    protected AdView zzfz;
    protected InterstitialAd zzga;
    private AdLoader zzgb;
    private Context zzgc;
    private InterstitialAd zzgd;
    private MediationRewardedVideoAdListener zzge;
    final RewardedVideoAdListener zzgf = new RewardedVideoAdListener(){

        @Override
        public void onRewardedVideoAdLoaded() {
            AbstractAdViewAdapter.this.zzge.onAdLoaded(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdOpened() {
            AbstractAdViewAdapter.this.zzge.onAdOpened(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoStarted() {
            AbstractAdViewAdapter.this.zzge.onVideoStarted(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdClosed() {
            AbstractAdViewAdapter.this.zzge.onAdClosed(AbstractAdViewAdapter.this);
            AbstractAdViewAdapter.this.zzgd = null;
        }

        @Override
        public void onRewarded(RewardItem rewardItem) {
            AbstractAdViewAdapter.this.zzge.onRewarded(AbstractAdViewAdapter.this, rewardItem);
        }

        @Override
        public void onRewardedVideoAdLeftApplication() {
            AbstractAdViewAdapter.this.zzge.onAdLeftApplication(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdFailedToLoad(int n) {
            AbstractAdViewAdapter.this.zzge.onAdFailedToLoad(AbstractAdViewAdapter.this, n);
        }
    };

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            builder.addTestDevice(zzm.zzjr().zzar(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzfz != null) {
            this.zzfz.destroy();
            this.zzfz = null;
        }
        if (this.zzga != null) {
            this.zzga = null;
        }
        if (this.zzgb != null) {
            this.zzgb = null;
        }
        if (this.zzgd != null) {
            this.zzgd = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzfz != null) {
            this.zzfz.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzfz != null) {
            this.zzfz.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzfz = new AdView(context);
        this.zzfz.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzfz.setAdUnitId(this.getAdUnitId(bundle));
        this.zzfz.setAdListener(new zzc(this, mediationBannerListener));
        this.zzfz.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzfz;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzga = new InterstitialAd(context);
        this.zzga.setAdUnitId(this.getAdUnitId(bundle));
        this.zzga.setAdListener(new zzd(this, mediationInterstitialListener));
        this.zzga.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showInterstitial() {
        this.zzga.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzbh(1).zzxg();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zze zze2 = new zze(this, mediationNativeListener);
        AdLoader.Builder builder = this.zza(context, bundle.getString(AD_UNIT_ID_PARAMETER)).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        this.zzgb = builder.build();
        this.zzgb.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    AdLoader.Builder zza(Context context, String string) {
        return new AdLoader.Builder(context, string);
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzgc = context.getApplicationContext();
        this.zzge = mediationRewardedVideoAdListener;
        this.zzge.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzgc == null || this.zzge == null) {
            com.google.android.gms.ads.internal.util.client.zzb.e("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzgd = new InterstitialAd(this.zzgc);
        this.zzgd.zzd(true);
        this.zzgd.setAdUnitId(this.getAdUnitId(bundle));
        this.zzgd.setRewardedVideoAdListener(this.zzgf);
        this.zzgd.loadAd(this.zza(this.zzgc, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzgd.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzge != null;
    }

    static class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzgi;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzgi = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzgi);
            }
        }
    }

    static class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzgh;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzgh = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzgh);
            }
        }
    }

    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzgj;
        final MediationNativeListener zzgm;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzgj = abstractAdViewAdapter;
            this.zzgm = mediationNativeListener;
        }

        @Override
        public void onAdLoaded() {
        }

        @Override
        public void onAdFailedToLoad(int n) {
            this.zzgm.onAdFailedToLoad(this.zzgj, n);
        }

        @Override
        public void onAdOpened() {
            this.zzgm.onAdOpened(this.zzgj);
        }

        @Override
        public void onAdClosed() {
            this.zzgm.onAdClosed(this.zzgj);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzgm.onAdLeftApplication(this.zzgj);
        }

        @Override
        public void onAdClicked() {
            this.zzgm.onAdClicked(this.zzgj);
        }

        @Override
        public void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzgm.onAdLoaded(this.zzgj, new zza(nativeAppInstallAd));
        }

        @Override
        public void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzgm.onAdLoaded(this.zzgj, new zzb(nativeContentAd));
        }
    }

    static final class zzd
    extends AdListener
    implements com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzgj;
        final MediationInterstitialListener zzgl;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzgj = abstractAdViewAdapter;
            this.zzgl = mediationInterstitialListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzgl.onAdLoaded(this.zzgj);
        }

        @Override
        public void onAdFailedToLoad(int n) {
            this.zzgl.onAdFailedToLoad(this.zzgj, n);
        }

        @Override
        public void onAdOpened() {
            this.zzgl.onAdOpened(this.zzgj);
        }

        @Override
        public void onAdClosed() {
            this.zzgl.onAdClosed(this.zzgj);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzgl.onAdLeftApplication(this.zzgj);
        }

        @Override
        public void onAdClicked() {
            this.zzgl.onAdClicked(this.zzgj);
        }
    }

    static final class zzc
    extends AdListener
    implements com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzgj;
        final MediationBannerListener zzgk;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzgj = abstractAdViewAdapter;
            this.zzgk = mediationBannerListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzgk.onAdLoaded(this.zzgj);
        }

        @Override
        public void onAdFailedToLoad(int n) {
            this.zzgk.onAdFailedToLoad(this.zzgj, n);
        }

        @Override
        public void onAdOpened() {
            this.zzgk.onAdOpened(this.zzgj);
        }

        @Override
        public void onAdClosed() {
            this.zzgk.onAdClosed(this.zzgj);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzgk.onAdLeftApplication(this.zzgj);
        }

        @Override
        public void onAdClicked() {
            this.zzgk.onAdClicked(this.zzgj);
        }
    }
}

