/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import com.google.android.gms.ads.internal.client.zzad;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzz;
import java.util.Date;
import java.util.List;
import java.util.Set;

public final class PublisherAdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final String DEVICE_ID_EMULATOR = zzad.DEVICE_ID_EMULATOR;
    private final zzad zzaju;

    private PublisherAdRequest(Builder builder) {
        this.zzaju = new zzad(builder.zzajv);
    }

    public Date getBirthday() {
        return this.zzaju.getBirthday();
    }

    public String getContentUrl() {
        return this.zzaju.getContentUrl();
    }

    public int getGender() {
        return this.zzaju.getGender();
    }

    public Set<String> getKeywords() {
        return this.zzaju.getKeywords();
    }

    public Location getLocation() {
        return this.zzaju.getLocation();
    }

    public boolean getManualImpressionsEnabled() {
        return this.zzaju.getManualImpressionsEnabled();
    }

    @Deprecated
    public <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzaju.getNetworkExtras(clazz);
    }

    public <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzaju.getNetworkExtrasBundle(clazz);
    }

    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzaju.getCustomEventExtrasBundle(clazz);
    }

    public String getPublisherProvidedId() {
        return this.zzaju.getPublisherProvidedId();
    }

    public boolean isTestDevice(Context context) {
        return this.zzaju.isTestDevice(context);
    }

    public Bundle getCustomTargeting() {
        return this.zzaju.getCustomTargeting();
    }

    public static void updateCorrelator() {
    }

    public zzad zzdg() {
        return this.zzaju;
    }

    public static final class Builder {
        private final zzad.zza zzajv = new zzad.zza();

        public Builder addKeyword(String string) {
            this.zzajv.zzai(string);
            return this;
        }

        public Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzajv.zza(networkExtras);
            return this;
        }

        public Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zzajv.zza(clazz, bundle);
            return this;
        }

        public Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzajv.zzb(clazz, bundle);
            return this;
        }

        public Builder addTestDevice(String string) {
            this.zzajv.zzaj(string);
            return this;
        }

        public PublisherAdRequest build() {
            return new PublisherAdRequest(this);
        }

        public Builder setBirthday(Date date) {
            this.zzajv.zza(date);
            return this;
        }

        public Builder setContentUrl(String string) {
            zzac.zzb((Object)string, (Object)"Content URL must be non-null.");
            zzac.zzh((String)string, (Object)"Content URL must be non-empty.");
            zzac.zzb((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzajv.zzal(string);
            return this;
        }

        public Builder setGender(int n) {
            this.zzajv.zzv(n);
            return this;
        }

        public Builder setLocation(Location location) {
            this.zzajv.zzb(location);
            return this;
        }

        @Deprecated
        public Builder setManualImpressionsEnabled(boolean bl) {
            this.zzajv.setManualImpressionsEnabled(bl);
            return this;
        }

        public Builder setPublisherProvidedId(String string) {
            this.zzajv.zzam(string);
            return this;
        }

        public Builder setRequestAgent(String string) {
            this.zzajv.zzan(string);
            return this;
        }

        public Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzajv.zzo(bl);
            return this;
        }

        public Builder addCustomTargeting(String string, String string2) {
            this.zzajv.zzf(string, string2);
            return this;
        }

        public Builder addCustomTargeting(String string, List<String> list) {
            if (list != null) {
                this.zzajv.zzf(string, zzz.zzhy((String)",").zza(list));
            }
            return this;
        }

        public Builder addCategoryExclusion(String string) {
            this.zzajv.zzao(string);
            return this;
        }

        public Builder setIsDesignedForFamilies(boolean bl) {
            this.zzajv.zzp(bl);
            return this;
        }
    }
}

