/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.Parcel;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.zzi;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.internal.zziy;

@zziy
public class AdSizeParcel
extends AbstractSafeParcelable {
    public static final zzi CREATOR = new zzi();
    public final int versionCode;
    public final String zzaxi;
    public final int height;
    public final int heightPixels;
    public final boolean zzaxj;
    public final int width;
    public final int widthPixels;
    public final AdSizeParcel[] zzaxk;
    public final boolean zzaxl;
    public final boolean zzaxm;
    public boolean zzaxn;

    public static int zza(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzb(DisplayMetrics displayMetrics) {
        return (int)((float)AdSizeParcel.zzc(displayMetrics) * displayMetrics.density);
    }

    private static int zzc(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static AdSizeParcel zzk(Context context) {
        return new AdSizeParcel(5, "320x50_mb", 0, 0, false, 0, 0, null, true, false, false);
    }

    public static AdSizeParcel zzjc() {
        return new AdSizeParcel(5, "reward_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public AdSizeParcel() {
        this(5, "interstitial_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public AdSizeParcel(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    public AdSizeParcel(Context context, AdSize[] adSizeArray) {
        int n;
        AdSize adSize = adSizeArray[0];
        this.versionCode = 5;
        this.zzaxj = false;
        this.zzaxm = adSize.isFluid();
        if (this.zzaxm) {
            this.width = AdSize.BANNER.getWidth();
            this.height = AdSize.BANNER.getHeight();
        } else {
            this.width = adSize.getWidth();
            this.height = adSize.getHeight();
        }
        boolean bl = this.width == -1;
        boolean bl2 = this.height == -2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (bl) {
            this.widthPixels = zzm.zzjr().zzat(context) && zzm.zzjr().zzau(context) ? AdSizeParcel.zza(displayMetrics) - zzm.zzjr().zzav(context) : AdSizeParcel.zza(displayMetrics);
            double d = (float)this.widthPixels / displayMetrics.density;
            n = (int)d;
            if (d - (double)((int)d) >= 0.01) {
                ++n;
            }
        } else {
            n = this.width;
            this.widthPixels = zzm.zzjr().zza(displayMetrics, this.width);
        }
        int n2 = bl2 ? AdSizeParcel.zzc(displayMetrics) : this.height;
        this.heightPixels = zzm.zzjr().zza(displayMetrics, n2);
        if (bl || bl2) {
            int n3 = n;
            this.zzaxi = new StringBuilder(26).append(n3).append("x").append(n2).append("_as").toString();
        } else {
            this.zzaxi = this.zzaxm ? "320x50_mb" : adSize.toString();
        }
        if (adSizeArray.length > 1) {
            this.zzaxk = new AdSizeParcel[adSizeArray.length];
            for (int i = 0; i < adSizeArray.length; ++i) {
                this.zzaxk[i] = new AdSizeParcel(context, adSizeArray[i]);
            }
        } else {
            this.zzaxk = null;
        }
        this.zzaxl = false;
        this.zzaxn = false;
    }

    public AdSizeParcel(AdSizeParcel adSizeParcel, AdSizeParcel[] adSizeParcelArray) {
        this(5, adSizeParcel.zzaxi, adSizeParcel.height, adSizeParcel.heightPixels, adSizeParcel.zzaxj, adSizeParcel.width, adSizeParcel.widthPixels, adSizeParcelArray, adSizeParcel.zzaxl, adSizeParcel.zzaxm, adSizeParcel.zzaxn);
    }

    AdSizeParcel(int n, String string, int n2, int n3, boolean bl, int n4, int n5, AdSizeParcel[] adSizeParcelArray, boolean bl2, boolean bl3, boolean bl4) {
        this.versionCode = n;
        this.zzaxi = string;
        this.height = n2;
        this.heightPixels = n3;
        this.zzaxj = bl;
        this.width = n4;
        this.widthPixels = n5;
        this.zzaxk = adSizeParcelArray;
        this.zzaxl = bl2;
        this.zzaxm = bl3;
        this.zzaxn = bl4;
    }

    public AdSize zzjd() {
        return zza.zza(this.width, this.height, this.zzaxi);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzi.zza(this, parcel, n);
    }

    public void zzl(boolean bl) {
        this.zzaxn = bl;
    }
}

