/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.internal.zziy;

@zziy
public final class zzk {
    private final AdSize[] zzaxp;
    private final String zzang;

    private static AdSize[] zzah(String string) {
        String[] stringArray = string.split("\\s*,\\s*");
        AdSize[] adSizeArray = new AdSize[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (string2.matches("^(\\d+|FULL_WIDTH)\\s*[xX]\\s*(\\d+|AUTO_HEIGHT)$")) {
                String[] stringArray2 = string2.split("[xX]");
                stringArray2[0] = stringArray2[0].trim();
                stringArray2[1] = stringArray2[1].trim();
                int n = 0;
                int n2 = 0;
                try {
                    n = "FULL_WIDTH".equals(stringArray2[0]) ? -1 : Integer.parseInt(stringArray2[0]);
                    n2 = "AUTO_HEIGHT".equals(stringArray2[1]) ? -2 : Integer.parseInt(stringArray2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = String.valueOf(string2);
                    throw new IllegalArgumentException(string3.length() != 0 ? "Could not parse XML attribute \"adSize\": ".concat(string3) : new String("Could not parse XML attribute \"adSize\": "));
                }
                adSizeArray[i] = new AdSize(n, n2);
                continue;
            }
            if ("BANNER".equals(string2)) {
                adSizeArray[i] = AdSize.BANNER;
                continue;
            }
            if ("LARGE_BANNER".equals(string2)) {
                adSizeArray[i] = AdSize.LARGE_BANNER;
                continue;
            }
            if ("FULL_BANNER".equals(string2)) {
                adSizeArray[i] = AdSize.FULL_BANNER;
                continue;
            }
            if ("LEADERBOARD".equals(string2)) {
                adSizeArray[i] = AdSize.LEADERBOARD;
                continue;
            }
            if ("MEDIUM_RECTANGLE".equals(string2)) {
                adSizeArray[i] = AdSize.MEDIUM_RECTANGLE;
                continue;
            }
            if ("SMART_BANNER".equals(string2)) {
                adSizeArray[i] = AdSize.SMART_BANNER;
                continue;
            }
            if ("WIDE_SKYSCRAPER".equals(string2)) {
                adSizeArray[i] = AdSize.WIDE_SKYSCRAPER;
                continue;
            }
            if ("FLUID".equals(string2)) {
                adSizeArray[i] = AdSize.FLUID;
                continue;
            }
            String string4 = String.valueOf(string2);
            throw new IllegalArgumentException(string4.length() != 0 ? "Could not parse XML attribute \"adSize\": ".concat(string4) : new String("Could not parse XML attribute \"adSize\": "));
        }
        if (adSizeArray.length == 0) {
            String string5 = String.valueOf(string);
            throw new IllegalArgumentException(string5.length() != 0 ? "Could not parse XML attribute \"adSize\": ".concat(string5) : new String("Could not parse XML attribute \"adSize\": "));
        }
        return adSizeArray;
    }

    public zzk(Context context, AttributeSet attributeSet) {
        boolean bl;
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.AdsAttrs);
        String string = typedArray.getString(R.styleable.AdsAttrs_adSize);
        String string2 = typedArray.getString(R.styleable.AdsAttrs_adSizes);
        boolean bl2 = !TextUtils.isEmpty((CharSequence)string);
        boolean bl3 = bl = !TextUtils.isEmpty((CharSequence)string2);
        if (bl2 && !bl) {
            this.zzaxp = zzk.zzah(string);
        } else if (!bl2 && bl) {
            this.zzaxp = zzk.zzah(string2);
        } else {
            if (bl2 && true) {
                throw new IllegalArgumentException("Either XML attribute \"adSize\" or XML attribute \"supportedAdSizes\" should be specified, but not both.");
            }
            throw new IllegalArgumentException("Required XML attribute \"adSize\" was missing.");
        }
        this.zzang = typedArray.getString(R.styleable.AdsAttrs_adUnitId);
        if (TextUtils.isEmpty((CharSequence)this.zzang)) {
            throw new IllegalArgumentException("Required XML attribute \"adUnitId\" was missing.");
        }
    }

    public AdSize[] zzm(boolean bl) {
        if (!bl && this.zzaxp.length != 1) {
            throw new IllegalArgumentException("The adSizes XML attribute is only allowed on PublisherAdViews.");
        }
        return this.zzaxp;
    }

    public String getAdUnitId() {
        return this.zzang;
    }
}

