/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzai;
import com.google.android.gms.ads.internal.client.zzaj;
import com.google.android.gms.ads.internal.client.zzak;
import com.google.android.gms.ads.internal.client.zzal;
import com.google.android.gms.ads.internal.client.zzam;
import com.google.android.gms.ads.internal.client.zzan;
import com.google.android.gms.ads.internal.client.zzd;
import com.google.android.gms.ads.internal.client.zze;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzs;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.client.zzx;
import com.google.android.gms.ads.internal.client.zzz;
import com.google.android.gms.ads.internal.reward.client.zzf;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzho;
import com.google.android.gms.internal.zzhp;
import com.google.android.gms.internal.zzhy;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zziy;

@zziy
public class zzl {
    private zzx zzaxq;
    private final Object zzakd = new Object();
    private final zze zzaxr;
    private final zzd zzaxs;
    private final zzai zzaxt;
    private final zzel zzaxu;
    private final zzf zzaxv;
    private final zzid zzaxw;
    private final zzho zzaxx;

    public zzl(zze zze2, zzd zzd2, zzai zzai2, zzel zzel2, zzf zzf2, zzid zzid2, zzho zzho2) {
        this.zzaxr = zze2;
        this.zzaxs = zzd2;
        this.zzaxt = zzai2;
        this.zzaxu = zzel2;
        this.zzaxv = zzf2;
        this.zzaxw = zzid2;
        this.zzaxx = zzho2;
    }

    @Nullable
    private static zzx zzje() {
        try {
            Object obj = zzl.class.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi").newInstance();
            if (!(obj instanceof IBinder)) {
                zzb.zzdf("ClientApi class is not an instance of IBinder");
                return null;
            }
            return zzx.zza.asInterface((IBinder)obj);
        }
        catch (Exception exception) {
            zzb.zzd("Failed to instantiate ClientApi class.", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private zzx zzjf() {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzaxq == null) {
                this.zzaxq = zzl.zzje();
            }
            return this.zzaxq;
        }
    }

    @VisibleForTesting
    <T> T zza(Context context, boolean bl, zza<T> zza2) {
        T t;
        if (!bl && !zzm.zzjr().zzas(context)) {
            zzb.zzdd("Google Play Services is not available");
            bl = true;
        }
        if (bl) {
            t = zza2.zzjo();
            if (t == null) {
                t = zza2.zzjp();
            }
        } else {
            t = zza2.zzjp();
            if (t == null) {
                t = zza2.zzjo();
            }
        }
        return t;
    }

    private void zzc(Context context, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("action", "no_ads_fallback");
        bundle.putString("flow", string);
        zzm.zzjr().zza(context, null, "gmob-apps", bundle, true);
    }

    public zzu zza(final Context context, final AdSizeParcel adSizeParcel, final String string, final zzgq zzgq2) {
        return this.zza(context, false, new zza<zzu>(){

            public zzu zza(zzx zzx2) throws RemoteException {
                return zzx2.createBannerAdManager(com.google.android.gms.dynamic.zze.zzac((Object)context), adSizeParcel, string, zzgq2, 9683000);
            }

            public zzu zzjg() {
                zzu zzu2 = zzl.this.zzaxr.zza(context, adSizeParcel, string, zzgq2, 1);
                if (zzu2 != null) {
                    return zzu2;
                }
                zzl.this.zzc(context, "banner");
                return new zzak();
            }

            @Override
            public /* synthetic */ Object zzjh() throws RemoteException {
                return this.zzjg();
            }

            @Override
            public /* synthetic */ Object zzb(zzx zzx2) throws RemoteException {
                return this.zza(zzx2);
            }
        });
    }

    public zzu zza(final Context context, final AdSizeParcel adSizeParcel, final String string) {
        return this.zza(context, false, new zza<zzu>(){

            public zzu zza(zzx zzx2) throws RemoteException {
                return zzx2.createSearchAdManager(com.google.android.gms.dynamic.zze.zzac((Object)context), adSizeParcel, string, 9683000);
            }

            public zzu zzjg() {
                zzu zzu2 = zzl.this.zzaxr.zza(context, adSizeParcel, string, null, 3);
                if (zzu2 != null) {
                    return zzu2;
                }
                zzl.this.zzc(context, "search");
                return new zzak();
            }

            @Override
            public /* synthetic */ Object zzjh() throws RemoteException {
                return this.zzjg();
            }

            @Override
            public /* synthetic */ Object zzb(zzx zzx2) throws RemoteException {
                return this.zza(zzx2);
            }
        });
    }

    public zzu zzb(final Context context, final AdSizeParcel adSizeParcel, final String string, final zzgq zzgq2) {
        return this.zza(context, false, new zza<zzu>(){

            public zzu zza(zzx zzx2) throws RemoteException {
                return zzx2.createInterstitialAdManager(com.google.android.gms.dynamic.zze.zzac((Object)context), adSizeParcel, string, zzgq2, 9683000);
            }

            public zzu zzjg() {
                zzu zzu2 = zzl.this.zzaxr.zza(context, adSizeParcel, string, zzgq2, 2);
                if (zzu2 != null) {
                    return zzu2;
                }
                zzl.this.zzc(context, "interstitial");
                return new zzak();
            }

            @Override
            public /* synthetic */ Object zzjh() throws RemoteException {
                return this.zzjg();
            }

            @Override
            public /* synthetic */ Object zzb(zzx zzx2) throws RemoteException {
                return this.zza(zzx2);
            }
        });
    }

    public zzs zzb(final Context context, final String string, final zzgq zzgq2) {
        return this.zza(context, false, new zza<zzs>(){

            public zzs zzc(zzx zzx2) throws RemoteException {
                return zzx2.createAdLoaderBuilder(com.google.android.gms.dynamic.zze.zzac((Object)context), string, zzgq2, 9683000);
            }

            public zzs zzji() {
                zzs zzs2 = zzl.this.zzaxs.zza(context, string, zzgq2);
                if (zzs2 != null) {
                    return zzs2;
                }
                zzl.this.zzc(context, "native_ad");
                return new zzaj();
            }

            @Override
            public /* synthetic */ Object zzjh() throws RemoteException {
                return this.zzji();
            }

            @Override
            public /* synthetic */ Object zzb(zzx zzx2) throws RemoteException {
                return this.zzc(zzx2);
            }
        });
    }

    public zzz zzl(final Context context) {
        return this.zza(context, false, new zza<zzz>(){

            public zzz zzd(zzx zzx2) throws RemoteException {
                return zzx2.getMobileAdsSettingsManagerWithClientJarVersion(com.google.android.gms.dynamic.zze.zzac((Object)context), 9683000);
            }

            public zzz zzjj() {
                zzz zzz2 = zzl.this.zzaxt.zzm(context);
                if (zzz2 != null) {
                    return zzz2;
                }
                zzl.this.zzc(context, "mobile_ads_settings");
                return new zzal();
            }

            @Override
            public /* synthetic */ Object zzjh() throws RemoteException {
                return this.zzjj();
            }

            @Override
            public /* synthetic */ Object zzb(zzx zzx2) throws RemoteException {
                return this.zzd(zzx2);
            }
        });
    }

    public zzdz zza(final Context context, final FrameLayout frameLayout, final FrameLayout frameLayout2) {
        return this.zza(context, false, new zza<zzdz>(){

            public zzdz zze(zzx zzx2) throws RemoteException {
                return zzx2.createNativeAdViewDelegate(com.google.android.gms.dynamic.zze.zzac((Object)frameLayout), com.google.android.gms.dynamic.zze.zzac((Object)frameLayout2));
            }

            public zzdz zzjk() {
                zzdz zzdz2 = zzl.this.zzaxu.zzb(context, frameLayout, frameLayout2);
                if (zzdz2 != null) {
                    return zzdz2;
                }
                zzl.this.zzc(context, "native_ad_view_delegate");
                return new zzam();
            }

            @Override
            public /* synthetic */ Object zzjh() throws RemoteException {
                return this.zzjk();
            }

            @Override
            public /* synthetic */ Object zzb(zzx zzx2) throws RemoteException {
                return this.zze(zzx2);
            }
        });
    }

    public com.google.android.gms.ads.internal.reward.client.zzb zza(final Context context, final zzgq zzgq2) {
        return this.zza(context, false, new zza<com.google.android.gms.ads.internal.reward.client.zzb>(){

            public com.google.android.gms.ads.internal.reward.client.zzb zzf(zzx zzx2) throws RemoteException {
                return zzx2.createRewardedVideoAd(com.google.android.gms.dynamic.zze.zzac((Object)context), zzgq2, 9683000);
            }

            public com.google.android.gms.ads.internal.reward.client.zzb zzjl() {
                com.google.android.gms.ads.internal.reward.client.zzb zzb2 = zzl.this.zzaxv.zzb(context, zzgq2);
                if (zzb2 != null) {
                    return zzb2;
                }
                zzl.this.zzc(context, "rewarded_video");
                return new zzan();
            }

            @Override
            public /* synthetic */ Object zzjh() throws RemoteException {
                return this.zzjl();
            }

            @Override
            public /* synthetic */ Object zzb(zzx zzx2) throws RemoteException {
                return this.zzf(zzx2);
            }
        });
    }

    @Nullable
    public zzhy zzb(final Activity activity) {
        boolean bl = zzl.zza(activity, "com.google.android.gms.ads.internal.purchase.useClientJar");
        return this.zza((Context)activity, bl, new zza<zzhy>(){

            public zzhy zzg(zzx zzx2) throws RemoteException {
                return zzx2.createInAppPurchaseManager(com.google.android.gms.dynamic.zze.zzac((Object)activity));
            }

            public zzhy zzjm() {
                zzhy zzhy2 = zzl.this.zzaxw.zzg(activity);
                if (zzhy2 != null) {
                    return zzhy2;
                }
                zzl.this.zzc((Context)activity, "iap");
                return null;
            }

            @Override
            public /* synthetic */ Object zzjh() throws RemoteException {
                return this.zzjm();
            }

            @Override
            public /* synthetic */ Object zzb(zzx zzx2) throws RemoteException {
                return this.zzg(zzx2);
            }
        });
    }

    @Nullable
    public zzhp zzc(final Activity activity) {
        boolean bl = zzl.zza(activity, "com.google.android.gms.ads.internal.overlay.useClientJar");
        return this.zza((Context)activity, bl, new zza<zzhp>(){

            public zzhp zzh(zzx zzx2) throws RemoteException {
                return zzx2.createAdOverlay(com.google.android.gms.dynamic.zze.zzac((Object)activity));
            }

            public zzhp zzjn() {
                zzhp zzhp2 = zzl.this.zzaxx.zzf(activity);
                if (zzhp2 != null) {
                    return zzhp2;
                }
                zzl.this.zzc((Context)activity, "ad_overlay");
                return null;
            }

            @Override
            public /* synthetic */ Object zzjh() throws RemoteException {
                return this.zzjn();
            }

            @Override
            public /* synthetic */ Object zzb(zzx zzx2) throws RemoteException {
                return this.zzh(zzx2);
            }
        });
    }

    private static boolean zza(Activity activity, String string) {
        Intent intent = activity.getIntent();
        if (!intent.hasExtra(string)) {
            zzb.e("useClientJar flag not found in activity intent extras.");
            return false;
        }
        return intent.getBooleanExtra(string, false);
    }

    @VisibleForTesting
    abstract class zza<T> {
        zza() {
        }

        @Nullable
        protected abstract T zzb(zzx var1) throws RemoteException;

        @Nullable
        protected abstract T zzjh() throws RemoteException;

        @Nullable
        protected final T zzjo() {
            zzx zzx2 = zzl.this.zzjf();
            if (zzx2 == null) {
                zzb.zzdf("ClientApi class cannot be loaded.");
                return null;
            }
            try {
                return this.zzb(zzx2);
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Cannot invoke local loader using ClientApi class", remoteException);
                return null;
            }
        }

        @Nullable
        protected final T zzjp() {
            try {
                return this.zzjh();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Cannot invoke remote loader", remoteException);
                return null;
            }
        }
    }
}

