/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.MediationServerParameters;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.ads.mediation.customevent.CustomEventAdapter;
import com.google.ads.mediation.customevent.CustomEventServerParameters;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.mediation.customevent.CustomEventExtras;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzgx;
import com.google.android.gms.internal.zzhc;
import com.google.android.gms.internal.zziy;
import java.util.Map;

@zziy
public final class zzgp
extends zzgq.zza {
    private Map<Class<? extends NetworkExtras>, NetworkExtras> zzbtx;

    @Override
    public zzgr zzbq(String string) throws RemoteException {
        return this.zzbs(string);
    }

    @Override
    public boolean zzbr(String string) throws RemoteException {
        try {
            Class<?> clazz = Class.forName(string, false, zzgp.class.getClassLoader());
            return CustomEvent.class.isAssignableFrom(clazz);
        }
        catch (Throwable throwable) {
            zzb.zzdf(new StringBuilder(80 + String.valueOf(string).length()).append("Could not load custom event implementation class: ").append(string).append(", assuming old implementation.").toString());
            return false;
        }
    }

    public void zzh(Map<Class<? extends NetworkExtras>, NetworkExtras> map) {
        this.zzbtx = map;
    }

    private <NETWORK_EXTRAS extends com.google.ads.mediation.NetworkExtras, SERVER_PARAMETERS extends MediationServerParameters> zzgr zzbs(String string) throws RemoteException {
        try {
            Class<?> clazz = Class.forName(string, false, zzgp.class.getClassLoader());
            if (com.google.ads.mediation.MediationAdapter.class.isAssignableFrom(clazz)) {
                com.google.ads.mediation.MediationAdapter mediationAdapter = (com.google.ads.mediation.MediationAdapter)clazz.newInstance();
                com.google.ads.mediation.NetworkExtras networkExtras = (com.google.ads.mediation.NetworkExtras)this.zzbtx.get(mediationAdapter.getAdditionalParametersType());
                return new zzhc(mediationAdapter, networkExtras);
            }
            if (MediationAdapter.class.isAssignableFrom(clazz)) {
                MediationAdapter mediationAdapter = (MediationAdapter)clazz.newInstance();
                return new zzgx(mediationAdapter);
            }
            zzb.zzdf(new StringBuilder(64 + String.valueOf(string).length()).append("Could not instantiate mediation adapter: ").append(string).append(" (not a valid adapter).").toString());
            throw new RemoteException();
        }
        catch (Throwable throwable) {
            return this.zzbt(string);
        }
    }

    private zzgr zzbt(String string) throws RemoteException {
        try {
            zzb.zzdd("Reflection failed, retrying using direct instantiation");
            if ("com.google.ads.mediation.admob.AdMobAdapter".equals(string)) {
                return new zzgx(new AdMobAdapter());
            }
            if ("com.google.ads.mediation.AdUrlAdapter".equals(string)) {
                return new zzgx(new AdUrlAdapter());
            }
            if ("com.google.android.gms.ads.mediation.customevent.CustomEventAdapter".equals(string)) {
                return new zzgx(new com.google.android.gms.ads.mediation.customevent.CustomEventAdapter());
            }
            if ("com.google.ads.mediation.customevent.CustomEventAdapter".equals(string)) {
                CustomEventAdapter customEventAdapter = new CustomEventAdapter();
                CustomEventExtras customEventExtras = (CustomEventExtras)this.zzbtx.get(customEventAdapter.getAdditionalParametersType());
                return new zzhc<CustomEventExtras, CustomEventServerParameters>(customEventAdapter, customEventExtras);
            }
        }
        catch (Throwable throwable) {
            zzb.zzd(new StringBuilder(43 + String.valueOf(string).length()).append("Could not instantiate mediation adapter: ").append(string).append(". ").toString(), throwable);
        }
        throw new RemoteException();
    }
}

